#ifndef __STACK_H__
#define __STACK_H__

#include <iostream>
#include <stdlib.h>

template<class T>
class Stack {
  class Elem {
  public:
    T data_;
    Elem *next_;
    Elem(const T &d, Elem *n) {
      data_ = d;
      next_ = n;
    }
  };

 public:

  class Iterator {
    friend class Stack<T>;
    Stack &stack;
    Elem *curr;
  public:
    Iterator(Stack &s, Elem *c) : stack(s), curr(c) {}

    inline Iterator &operator++() {      // pre-increment
      if (curr != 0) curr = curr->next_;
      return *this;
    }
    const Iterator operator++(int) {   // post-increment
      Iterator z(*this);
      this->operator++();
      return z;
    }

    inline T operator*() const {
      if (curr != 0) return curr->data_;
      else return 0;
    }

    inline bool operator==(const Iterator &i) const {
      return curr == i.curr;
    }

    inline bool operator!=(const Iterator &i) const {
      return !operator==(i);
    }

  };

  Stack() : head_(0), size_(0) {}
  ~Stack() {
    // delete all elements!
    while (head_ != 0) {
      Elem *temp = head_;
      head_ = temp->next_;
      delete temp;
    }
  }

  void push(const T &a) {
    head_ = new Elem(a, head_);
    size_ ++;
  }

  T pop() {
    if (head_ == 0) {
      std::cerr << "Empty Stack!\n";
      exit(-1);
    }

    Elem *temp = head_;
    head_ = temp->next_;
    T data = temp->data_;
    delete temp;
    size_ --;
    return data;
  }

  inline int size() {return size_;}

  inline Iterator begin() { return Iterator(*this, head_); }
  inline Iterator end() { return Iterator(*this, 0); }

 private:
  Elem *head_;
  int size_;
};

#endif
