#include <iostream>
#include "stack.h"

Stack::Elem::Elem(int d, Elem *n)
{
  data_ = d;
  next_ = n;
}

Stack::Stack()
{
  head_ = 0;
  size_ = 0;
}

Stack::~Stack()
{
  // delete all elements!
  while (head_ != 0) {
    Elem *temp = head_;
    head_ = temp->next_;
    delete temp;
  }
}

void Stack::push(int a)
{
  head_ = new Elem(a, head_);
  size_ ++;
}

int Stack::pop()
{
  if (head_ == 0) {
    cerr << "Empty Stack!\n";
    exit(-1);
  }

  Elem *temp = head_;
  head_ = temp->next_;
  int data = temp->data_;
  delete temp;
  size_ --;
  return data;
}

int Stack::size()
{
  return size_;
}

int Stack::operator[](int idx) throw (OutOfRange)
{
  int i = 0;
  Elem *p = head_;

  while (p != 0 && i < idx) {
    p = p->next_;
    ++i;
  }
  if (p == 0) throw OutOfRange();
  else return p->data_;
}
