#include "listshapes.h"

ListShapes::Iterator::Iterator(ListShapes &l, Elem *c) : list(l), curr(c) 
{}

ListShapes::Iterator::Iterator(const ListShapes::Iterator &i) : list(i.list), curr(i.curr) 
{}

ListShapes::Iterator & ListShapes::Iterator::operator=(const ListShapes::Iterator &i) {
	list = i.list;
	curr = i.curr;

	return *this;
} 

bool ListShapes::Iterator::operator==(const ListShapes::Iterator &i)
{
	return (curr == i.curr);
} 

bool ListShapes::Iterator::operator!=(const ListShapes::Iterator &i)
{
	return !(this->operator==(i));
} 

Shape & ListShapes::Iterator::operator*() const
{
	return *(curr->p);
}

ListShapes::Iterator & ListShapes::Iterator::operator++() 
{
	if (curr != 0) 
		curr = curr->next;	
	return *this;
}

ListShapes::Iterator ListShapes::Iterator::operator++(int) 
{
	Iterator tmp(*this);
	
	++(*this);
	
	return tmp;
}


ListShapes::ListShapes() : head(0) 
{
}

void ListShapes::addShape(Shape *myshape)
{
	Elem *tmp = new Elem;
	tmp->p = myshape;

	tmp->next = head;
	
	head = tmp;
}

ListShapes::Iterator ListShapes::begin()
{
	return Iterator(*this, head);
}

ListShapes::Iterator ListShapes::end()
{
	return Iterator(*this, 0);
}

