#ifndef __LIST_SHAPES__
#define __LIST_SHAPES__

#include "shape.h"

class ListShapes {
	class Elem {
	public:
		Shape *p;
		Elem *next;
	};

	Elem *head;

public:
	class Iterator {
		friend class ListShapes;

		ListShapes &list;

		Elem *curr;

	public:
		Iterator(ListShapes &s, Elem *c);
		Iterator(const Iterator &i);
	
		Iterator &operator=(const Iterator &i);
		bool operator==(const Iterator &i);
		bool operator!=(const Iterator &i);

	    	Shape& operator*() const;

		Iterator &operator++();
		Iterator operator++(int);
	};

	Iterator begin();
	Iterator end();

	ListShapes();
	void addShape(Shape *p);
	//void removeShape(Shape *p);
};

#endif
