#include <strstream>
#include <string>
#include <cstdlib>
#include "owner.h"

#define PRINT(x) cout << #x " contains A(" << x.getA().get() << ")" << endl; 

using namespace std;

string *getNewName()
{
  static int i = 0;       // do you remember the meaning of
                          // static in this case?

  char buf[10];
  ostrstream str(buf,10);
  string *t;
  
  str << "Name_" << i++;

  t = new string(str.str());
  return t;
}

int main()
{
  string *s = getNewName();
  string *s1 = getNewName();

  // The simplest example:

  s = getNewName();      // Memory leak! We are losing the handle 
                         // to the old string!

  cout << "Now the value pointed by s is: <" << *s
       << "> and s1 is: <" << *s1 << ">\n";

  {
    A a(1);
    B b1(&a);     // ERROR! b1 now owns a, so now there are two owners!
    PRINT(b1);    // one is main and the other is b1.
  }

  A *p = new A(2);
  B b2(p);      // Ok, now B is owner

  PRINT(b2);

  p = new A(3);   // Ok, we can forget about previous A(1)
                  // because b2 is responsible for desctruction
                   
  b2.setNewA(p);  // Ok, b2 will destroy old A before acquiring
                  // new A

  p = 0;          // Ok, again
 
  PRINT(b2);

  delete s;
  delete s1;

  // last A is automatically deleted by b2 destructor
#ifndef CYGNUS
  system("pause");
#endif
}
