#include <iostream>
using namespace std;

/* This example demonstrates the issue of ownership
   in C++. Class B has a pointer to class A: it is
   "owner" of class A: it means that, whenever a pointer
   to an object of class A is passed to the constructor
   of B, B becomes responsible for its destruction.
   Can you say why class B hides copy constructor? */
class A {
  int ii;
 public:
  A(int i) : ii(i) {cout << "A(" << ii << ") called\n"; }

  ~A() {cout << "~A(" << ii << ") called\n";}

  int get() const {return ii;}
};

class B {
  A *pa;
  B(B&);
 public:
  B();
  B(A *a);
  ~B();

  const A &getA();
  void setNewA(A *a);
};
