#include <stdlib.h>
#include <iostream>
#include "smartptr.h"

using namespace std;

int main(int argc, char *argv[])
{
  SSP p1 = A::getNew("Obj1");
  SSP p2 = A::getNew("Obj2");

  p2 = (A*) (0xff45632);

  cout << "Number of pointers to " << p1->getName()
       << " is " << p1->getNumber() << "\n";

  cout << "Number of pointers to " << p2->getName()
       << " is " << p2->getNumber() << "\n";

  SSP array[5];

  for (int i=0; i<5; ++i) array[i] = p1;

  cout << "Number of pointers to " << p1->getName()
       << " is " << p1->getNumber() << "\n";

  cout << "Number of pointers to " << p2->getName()
       << " is " << p2->getNumber() << "\n";

  p2 = p1;

  cout << "Number of pointers to " << p1->getName()
       << " is " << p1->getNumber() << "\n";

  // now we try to deallocate

  for (int i=0; i<5; ++i) {
    array[i] = 0;
    cout << "Number of pointers to " << p1->getName()
         << " is " << p1->getNumber() << "\n";
  }

  p1 = 0;
  p2 = 0;

  return 0;
}
