#include <iostream>
#include <string>
#include "smartptr.h"

using namespace std;

A::A(const string &n) : name(n), number(0)
{
}

const string& A::getName()
{
  return name;
}

int A::getNumber()
{
  return number;
}

A* A::getNew(const string &n)
{
  return new A(n);
}

A::~A()
{
  cout << "Destructor of " << name << " has been called!\n";
}

SSP::SSP() : ptr(0)
{
}

SSP::SSP(A* a): ptr(a)
{
  if (dynamic_cast<A *>(a)) a->number++;
}

SSP::SSP(const SSP &other) : ptr(other.ptr)
{
  if (dynamic_cast<A *>(ptr)) ptr->number++;
}

SSP::~SSP()
{
  if (dynamic_cast<A *>(ptr)) {
    ptr->number--;
    if (ptr->number == 0) delete ptr;
  }
}


SSP& SSP::operator++()
{
  ++ptr;
  return *this;
}

const SSP SSP::operator++(int)
{
  SSP z(*this);
  ++ptr;
  return z;
}

SSP& SSP::operator--()
{
  --ptr;
  return *this;
}

const SSP SSP::operator--(int)
{
  SSP z(*this);
  --ptr;
  return z;
}

SSP& SSP::operator=(const SSP& other)
{
  if (other != this) {
  	if (dynamic_cast<A *>(ptr)) {
    		ptr->number--;
    		if (ptr->number == 0) delete ptr;
  	}
  	ptr = other.ptr;
  	if (dynamic_cast<A *>(ptr)) ptr->number++;
  }
  return *this;
}

bool SSP::operator==(const SSP& other)
{
  return ptr == other.ptr;
}

bool SSP::operator!=(const SSP& other)
{
  return !operator==(other);
}

A& SSP::operator*() const
{
  if (dynamic_cast<A *>(ptr)) return *ptr;
  else {
    cerr << "I'm dereferencing a non-valid pointer!\n";
    string str;
    cin >> str;
    exit(-1);
  }
}

A* SSP::operator->() const
{
  if (dynamic_cast<A *>(ptr)) return ptr;
  else {
    cerr << "I'm dereferencing a non-valid pointer!\n";
    string str;
    cin >> str;
    exit(-1);
  }
}

