#include <string>

using namespace std;

/* In this example, I defined a SmartPointer for class A. This
   SmartPointer behaves as follows:
   - Every object of class A has a integer number that counts the
     number of pointers that refer to the object
   - You can create objects of class A only by calling the
     static member getNew() that returns a pointer to the object
   - Every object of class SSP behaves exactly like a pointer
     to an object of class A
   - When you assign a pointer to A to a smart pointer, it increments
     the counter stored in A
   - The old object, that was pointed by the smart pointer, get the
     counter decremented;
   - Whenever the counter reaches 0, the smart pointer deletes the
     object
   */
class A {
  friend class SSP;

  string name;
  int number;

  A(const string &n);
  A(const A&);
  A& operator=(const A&);
  ~A();
public:
  const string& getName();
  int getNumber();
  static A* getNew(const string &n);
};

class SSP {
  A* ptr;
public:
  SSP();
  SSP(A* a);
  SSP(const SSP& other);

  ~SSP();

  SSP& operator=(const SSP& other);

  A& operator*() const;
  A* operator->() const;

  SSP& operator++();
  const SSP  operator++(int);
  SSP& operator--();
  const SSP  operator--(int);
  bool operator==(const SSP& other);
  bool operator!=(const SSP& other);
};
