#include <iostream>
#include "stack.h"

Stack::Elem::Elem(int d, Elem *n)
{
  data_ = d;
  next_ = n;
}

Stack::Iterator::Iterator(Stack &s, Stack::Elem *c) : stack(s), curr(c)
{
}

Stack::Iterator& Stack::Iterator::operator++()
{
  if (curr != 0) curr = curr->next_;
  return *this;
}

const Stack::Iterator Stack::Iterator::operator++(int)
{
  Iterator z(*this);
  this->operator++();
  return z;
}

int Stack::Iterator::operator*() const
{
  if (curr != 0) return curr->data_;
  else return 0;
}

bool Stack::Iterator::operator==(const Iterator &i) const
{
  return curr == i.curr;
}

bool Stack::Iterator::operator!=(const Iterator &i) const
{
  return !operator==(i);
}

Stack::Stack()
{
  head_ = 0;
  size_ = 0;
}

Stack::~Stack()
{
  // delete all elements!
  while (head_ != 0) {
    Elem *temp = head_;
    head_ = temp->next_;
    delete temp;
  }
}

void Stack::push(int a)
{
  head_ = new Elem(a, head_);
  size_ ++;
}

int Stack::pop()
{
  if (head_ == 0) {
    cerr << "Empty Stack!\n";
    exit(-1);
  }

  Elem *temp = head_;
  head_ = temp->next_;
  int data = temp->data_;
  delete temp;
  size_ --;
  return data;
}

int Stack::size()
{
  return size_;
}

Stack::Iterator Stack::begin()
{
  return Iterator(*this, head_);
}

Stack::Iterator Stack::end()
{
  return Iterator(*this, 0);
}
