class Stack {
  class Elem {
  public:
    int data_;
    Elem *next_;
    Elem(int d, Elem *n);
  };


 public:

  class Iterator {
    friend class Stack;
    Stack &stack;
    Elem *curr;
  public:
    Iterator(Stack &s, Elem *c);

    Iterator &operator++();      // pre-increment
    const Iterator operator++(int);   // post-increment

    int operator*() const;

    bool operator==(const Iterator &i) const;
    bool operator!=(const Iterator &i) const;
  };

  Stack();
  ~Stack();

  void push(int a);
  int pop();
  int size();
  Iterator begin();
  Iterator end();

 private:
  Elem *head_;
  int size_;
};
