#include <string>
#include <vector>
#include <algorithm>

struct Entry {
    string name;
    int number;
};

vector<Entry> phone_book;      // initially, only 10 elements 

bool operator < (const Entry &a, const Entry &b) 
{
  return a.name < b.name;
}

void add_entry(const string &n, int num)
{
  Entry tmp;
  tmp.name = n;
  tmp.number = num;
  phone_book.push_back(tmp);
}

void print_entry(const Entry &e)
{
  cout << e.name << " \t " << e.number << endl;
}


int main()
{
  add_entry("Lipari Giuseppe", 1234);
  add_entry("Ancilotti Paolo", 2345);
  add_entry("Cecchetti Gabriele", 3456);
  add_entry("Domenici Andrea", 4567);
  add_entry("Di Natale Marco", 5678);

  cout << "Before ordering ... " << endl;
  for_each(phone_book.begin(), phone_book.end(), print_entry);

  sort(phone_book.begin(), phone_book.end());

  cout << "After ordering !" << endl;
  for_each(phone_book.begin(), phone_book.end(), print_entry);
}



