#include <iostream>
#include "stack.h"

Stack::Stack(int size)
{
  array_ = new int[size];
  size_ = size;

  for (int i=0; i<size_; ++i) array_[i] = 0;
  top_ = 0;
}

Stack::~Stack()
{
  delete []array_;
}

void Stack::push(int a)
{
  if (top_ == size_) {
    cerr << "Stack full!!" << endl;
    exit(-1);
  }
  
  array_[top_++] = a;
}

int Stack::pop()
{
  if (top_ == 0) {
    cerr << "Stack empty!" << endl;
    exit(-1);
  }
  return array_[--top_];
}

int Stack::size()
{
  return top_;
}
