#include "integrator.h"
#include "sinsource.h"
#include "simulation.h"
#include <iostream>

using namespace std;
using namespace DiscreteTimeSystems;

int main()
{
  Simulation::getInstance()->setTimeStep(0.001);

  Block * block_sequence[2];

  block_sequence[0] = new SinSource(100, 2);
  block_sequence[1] = new Integrator(10);

  InputPort *ip2 = block_sequence[1]->getInputPort(0);
  OutputPort *op1 = block_sequence[0]->getOutputPort(0);

  ip2->connect(op1);

  for(int i=0; i<1000; ++i) {
    for (int j=0; j<2; j++) 
      block_sequence[j]->updateState();

    for (int j=0; j<2; j++)
      block_sequence[j]->updateOutput();
    
    OutputPort *op2 = block_sequence[1]->getOutputPort(0);

    vector<double> v = op2->getData();
    
    cout << "" << Simulation::getInstance()->getTime();
    cout << ", " << v[0] << endl; 
				     
    Simulation::getInstance()->advance();
  }
}
