#ifndef __BLOCK_H__
#define __BLOCK_H__

#include "port.h"

namespace DiscreteTimeSystems {

  /**
     Abstract class for simulating blocks
   */
  class Block {
  protected:
    std::vector<InputPort *> _in_ports;
    std::vector<OutputPort *> _out_ports;
  public:
    /**
       Constructor for the Block class
     */
    Block();

    /**
     */
    virtual ~Block() {}

    /**
       Get the pointer to the n-th input port. Returns NULL if the
       block has less than n input ports
     */
    InputPort *getInputPort(int n);

    /**
       Get the pointer to the n-th ouput port. Returns NULL if the
       block has less than n output ports.
     */
    OutputPort *getOutputPort(int n);

    /**
       Returns true if this is a stateful block
     */
    virtual bool isStatefulBlock() = 0;

    /**
       Updates the block state, but does not update the output
     */
    virtual void updateState() = 0;
    
    /**
       Only updates the output
     */
    virtual void updateOutput() = 0;
  };
}


#endif // __BLOCK_H__ 
