#ifndef __INTEGRATOR_H__
#define __INTEGRATOR_H__

#include "block.h"
#include <deque>

namespace DiscreteTimeSystems {

  class Integrator : public Block {
    
    std::deque<double> memory;
    
  public:
    Integrator(int n);
    
    virtual ~Integrator();
    
    /**
       Returns true if this is a stateful block
    */
    virtual bool isStatefulBlock() { return true ;}
    
    /**
       Updates the block state, but does not update the output
    */
    virtual void updateState();

    /**
       Only updates the output
    */
    virtual void updateOutput();
  };  
}

#endif
