#ifndef __PORT_H__
#define __PORT_H__

#include <vector>

namespace DiscreteTimeSystems {

  class Block;

  /** 
     This class models an output port of a block
   */
  class OutputPort {
    std::vector<double> _array;
    int _size;
    int update_time;
    Block *myblock;
  public:
    /// Constructor of OutputPort, size is the number of reals stored
    /// in this port
    OutputPort(int size);

    /// returns the number of real stored in this block
    int getSize() { return _size; }
    
    /// returns (a copy of) the vector of reals stored in this block
    std::vector<double> getData();

    /// stores a new element in the internal array
    void setData(const std::vector<double> &d);
  };

  /**
     This class models an input port of a block
   */
  class InputPort {
    OutputPort *_port;
    int _size;
  public:
    /** 
	constructor of Input port
	@param size number of real numbers required by this port
    */
    InputPort(int size);

    /**
       connects this input port to the preceding outport (of the
       preceding block).
     */
    void connect(OutputPort *p);

    /**
       returns the number of real numbers required by this port
     */
    int getSize() { return _size; }

    /**
       Returns the data stored in the output port to which this input
       port is connected.
     */
    std::vector<double> getData();

  };
}
#endif

