#ifndef __SINSOURCE_H__
#define __SINSOURCE_H__

#include "block.h"

namespace DiscreteTimeSystems {

  class SinSource : public Block {
    double _freq;
    double _amp;
  public:
    SinSource(double f, double a);

    /**
       Returns true if this is a stateful block
     */
    virtual bool isStatefulBlock() { return false; }

    /**
       Updates the block state, but does not update the output
     */
    virtual void updateState() {}
    
    /**
       Only updates the output
     */
    virtual void updateOutput();

  };
  
}

#endif
