#include "integrator.h"

namespace  DiscreteTimeSystems {

  using namespace std;
  
  Integrator::Integrator(int n) : Block(), memory(n)
  {
    OutputPort *op = new OutputPort(1);
    InputPort *ip = new InputPort(1);

    _out_ports.push_back(op);
    _in_ports.push_back(ip);
    
    for (int i=0; i<n; ++i) 
      memory.push_back(0);
  }

  Integrator::~Integrator()
  {
    OutputPort *op = _out_ports[0];
    InputPort *ip = _in_ports[0];
    delete op;
    delete ip;
  }

  void Integrator::updateState()
  {
    vector<double> vd = _in_ports[0]->getData();

    memory.push_back(vd[0]);

    memory.pop_front();
  }

  void Integrator::updateOutput()
  {
    OutputPort *op = _out_ports[0];

    double data = 0;
    for (int i=0; i<memory.size(); ++i) 
      data += memory[i];

    data /= memory.size();

    vector<double> v; 
    v.push_back(data);

    op->setData(v);
  }

}
