#include "port.h"

namespace  DiscreteTimeSystems {

  using namespace std;

  InputPort::InputPort(int n) : _size(n), _port(NULL)
  {
  }

  void InputPort::connect(OutputPort *p)
  {
    if (_size != p->getSize()) {
      exit(-1);
    }

    _port = p;
  }

  vector<double> InputPort::getData()
  {
    if (_port) 
      return _port->getData();
    else 
      exit(-1);
  }

  OutputPort::OutputPort(int n) : _array(n), _size(n)
  {
    for (int i=0; i<n; ++i) _array.push_back(0);
  }

  vector<double> OutputPort::getData()
  {
    return _array;
  }

  void OutputPort::setData(const vector<double> &v)
  {
    if (v.size() != _size) 
      exit(-1);
    _array = v;
  }
}

