#include "simulation.h"

namespace DiscreteTimeSystems {

  Simulation * Simulation::_instance = 0;

  Simulation::Simulation() : _time(0), _time_step(1)
  {
  }

  Simulation * Simulation::getInstance()
  {
    if (_instance == 0) _instance = new Simulation();
    
    return _instance;
  }

  void Simulation::setTimeStep(double ts)
  {
    _time_step = ts;
  }

  double Simulation::getTime()
  {
    return _time * _time_step;
  }

  int Simulation::getStep()
  {
    return _time;
  }

  void Simulation::advance()
  {
    ++_time;
  }
}

