#include "sinsource.h"
#include <math.h>
#include "simulation.h"

namespace DiscreteTimeSystems {

  using namespace std;

  SinSource::SinSource(double f, double a) : Block(), _freq(f), _amp(a)
  {
    OutputPort *op = new OutputPort(1);

    _out_ports.push_back(op);
  }

  void SinSource::updateOutput()
  {
    double curr_time = Simulation::getInstance()->getTime();

    double data = _amp * sin( _freq * curr_time ) ;

    vector<double> v; 
    v.push_back(data);

    _out_ports[0]->setData(v);
  }
}
