#include <stdlib.h>
#include <stdio.h>
#include "tree.h"

void tree_insert(struct TElem **root, int d)
{
	int lh, rh;
	if (*root == 0) {
		*root = malloc(sizeof(struct TElem));
		(*root)->dato = d;
		(*root)->left = 0;
		(*root)->right = 0;
		(*root)->parent = 0;
		(*root)->height = 0;
	}
	else {
		if (d < (*root)->dato) {
			tree_insert(&((*root)->left), d);
			(*root)->left->parent = *root;

			lh = (*root)->left->height; 
			if ((*root)->right != 0) rh = (*root)->right->height; 	
			else rh = 0;
			if (lh > rh) (*root)->height = lh +1;
			else (*root)->height = rh +1;
		}
		else if (d > (*root)->dato) {
			tree_insert(&((*root)->right), d);
			(*root)->right->parent = *root;

			rh = (*root)->right->height; 
			if ((*root)->left != 0) lh = (*root)->left->height; 	
			else lh = 0;
			if (lh > rh) (*root)->height = lh +1;
			else (*root)->height = rh +1;
		}
	}
}

void tree_print_ordered(struct TElem *root)
{
	if (root == 0) return;
	else {
		tree_print_ordered(root->left);
		printf("(%d)[%d] ", root->dato, root->height);
		tree_print_ordered(root->right);
	}
}

void tree_print_level(struct TElem *root)
{
	
}

