/*
  In this example, a simple system is simulated, consisting of two
  real-time tasks scheduled by Round Robin on a single processor.
*/
#include <rtlib.hpp>
#include <fpsched.hpp>
#include <task.hpp>
#include <taskstat.hpp>
#include <acttask.hpp>
#include <fpsched.hpp>
#include <kernel.hpp>
#include <deque>
#include <algorithm>

using namespace MetaSim;

using namespace Simulation;
using namespace RTSim;
using namespace std;


namespace RTSim
{
    class MyScheduler;
	      class MyPeriodicEvent : public Event
	      {
				MyScheduler *s;
				int quantum;
				public:
					MyPeriodicEvent(MyScheduler *ms, int q) : s(ms), quantum(q){}
				void doit();
		  };

		  class MyScheduler : public RTScheduler
		  {
				MyPeriodicEvent myEvent;
				typedef deque <AbsTask *> INTDEQUE;
				INTDEQUE  dequetest;
				int quantum;

				class MyModel: public RTModel
				{
					Tick _prio;
					public:
					MyModel(AbsRTTask *t, Tick p) : RTModel(t), _prio(p) {}
				    Tick getPriority() { return _prio; }
				    void setPriority(Tick p) {_prio = p; }
                    void changePriority(Tick p) {setPriority(p);}
    		    };

		  public:
	      		MyScheduler(int q) : myEvent(this, q), quantum(q){}

				void MyaddTask(AbsRTTask *task, int prio) throw(RTSchedExc)
				{
					  MyModel *model = new MyModel(task, prio);
                      if (find(task) != NULL) throw RTSchedExc("Element already present");
					  _tasks[task] = model;
                      if (!_kernel) throw RTSchedExc("Kernel not set!");
					  _kernel->addTask(task);
				}

				void insert(AbsTask *task) throw(RTSchedExc, BaseExc)   //Called by _kernel->activate()
				{

					  dequetest.push_back(task);

				}

				void extract(AbsTask *t) throw(RTSchedExc, BaseExc) //Called by _kernel->suspend()
				{
					  dequetest.erase(std::find(dequetest.begin(),dequetest.end(),t));
	            }

	            AbsTask *getFirst()
	            {
					return dequetest.front();
				}

				void newRun()
			    {
					myEvent.post(0);
			    }

				void refresh()
				{

				}

               /*This is the basic function where the Round Robin is 
			     implemented. The dequeue is roated at this stage and the 
				 _kernelp->dispatch method is called to perform the
				 context switch*/
				void functionality()
				{
					AbsTask *myTask, *myNewTask;
					myTask = dequetest.front();
					dequetest.pop_front();
					dequetest.push_back(myTask);
					myNewTask = dequetest.front();
					_kernel->dispatch();
				}
          };

    void MyPeriodicEvent::doit()
    {
		if(getTime()!=0)
		{
			s->functionality();
			post(getTime()+quantum);
		}
		else
			post(getTime()+quantum);
	}

}   // Close RTSIM Namespace





int main()
{
	int quant;
	cout<<"\n\n\tWhat is the quantum you want to set?   ";
	cin>>quant;
    try {

	JavaTrace jtrace("trace.trc");

	MyScheduler mySched(quant);
	RTKernel kern(&mySched);
	mySched.setKernel(&kern);

	PeriodicTask t1(60,80,0,"Task A");
	PeriodicTask t2(60,80,0,"Task B");
	PeriodicTask t3(60,80,0,"Task C");
	PeriodicTask t4(60,80,0,"Task D");
	/*PeriodicTask t5(10,50,0,"Task E");
	PeriodicTask t6(10,50,0,"Task F");
	PeriodicTask t7(10,50,0,"Task G");
	PeriodicTask t8(10,50,0,"Task H");*/

	mySched.MyaddTask(&t1,1);
	mySched.MyaddTask(&t2,1);
	mySched.MyaddTask(&t3,1);
	mySched.MyaddTask(&t4,1);
	/*mySched.MyaddTask(&t5,1);
	mySched.MyaddTask(&t6,1);
	mySched.MyaddTask(&t7,1);
	mySched.MyaddTask(&t8,1);*/

	t1.insertCode("delay(unif(50,55));");
	t2.insertCode("delay(unif(50,55));");
	t3.insertCode("delay(unif(50,55));");
	t4.insertCode("delay(unif(50,55));");
	/*t5.insertCode("delay(unif(4,5));");
	t6.insertCode("delay(unif(4,5));");
	t7.insertCode("delay(unif(4,5));");
	t8.insertCode("delay(unif(4,5));");*/

    t1.setAbort(false);
    t2.setAbort(false);
    t3.setAbort(false);
    t4.setAbort(false);
	/*t5.setAbort(false);
	t6.setAbort(false);
	t7.setAbort(false);
    t8.setAbort(false);*/

    t1.setTrace(&jtrace);
    t2.setTrace(&jtrace);
    t3.setTrace(&jtrace);
    t4.setTrace(&jtrace);
	/*t5.setTrace(&jtrace);
	t6.setTrace(&jtrace);
	t7.setTrace(&jtrace);
    t8.setTrace(&jtrace);*/

    FinishingTimeStat<StatMean> finishstat1("mystat1");
	FinishingTimeStat<StatMean> finishstat2("mystat2");
	FinishingTimeStat<StatMean> finishstat3("mystat3");
	FinishingTimeStat<StatMean> finishstat4("mystat4");
	/*FinishingTimeStat<StatMean> finishstat5("mystat5");
	FinishingTimeStat<StatMean> finishstat6("mystat6");
	FinishingTimeStat<StatMean> finishstat7("mystat7");
	FinishingTimeStat<StatMean> finishstat8("mystat8");*/

	WaitingTimeStat<StatMean> waitstat1("waitstat1");
	WaitingTimeStat<StatMean> waitstat2("waitstat2");
	WaitingTimeStat<StatMean> waitstat3("waitstat3");
	WaitingTimeStat<StatMean> waitstat4("waitstat4");
	/*WaitingTimeStat<StatMean> waitstat5("waitstat5");
	WaitingTimeStat<StatMean> waitstat6("waitstat6");
	WaitingTimeStat<StatMean> waitstat7("waitstat7");
	WaitingTimeStat<StatMean> waitstat8("waitstat8");*/

	NTATimeStat<StatMean> ntatstat1("ntatstat1");
	NTATimeStat<StatMean> ntatstat2("ntatstat2");
	NTATimeStat<StatMean> ntatstat3("ntatstat3");
	NTATimeStat<StatMean> ntatstat4("ntatstat4");
	/*NTATimeStat<StatMean> ntatstat5("ntatstat5");
	NTATimeStat<StatMean> ntatstat6("ntatstat6");
	NTATimeStat<StatMean> ntatstat7("ntatstat7");
	NTATimeStat<StatMean> ntatstat8("ntatstat8");*/

	ServiceTimeStat<StatMean> servicestat1("servicestat1");
	ServiceTimeStat<StatMean> servicestat2("servicestat2");
	ServiceTimeStat<StatMean> servicestat3("servicestat3");
	ServiceTimeStat<StatMean> servicestat4("servicestat4");
	/*ServiceTimeStat<StatMean> servicestat5("servicestat5");
	ServiceTimeStat<StatMean> servicestat6("servicestat6");
	ServiceTimeStat<StatMean> servicestat7("servicestat7");
	ServiceTimeStat<StatMean> servicestat8("servicestat8");*/

	finishstat1.attach(&t1);
	finishstat2.attach(&t2);
	finishstat3.attach(&t3);
	finishstat4.attach(&t4);
	/*finishstat5.attach(&t5);
	finishstat6.attach(&t6);
	finishstat7.attach(&t7);
	finishstat8.attach(&t8);*/

	waitstat1.attach(&t1);
	waitstat2.attach(&t2);
	waitstat3.attach(&t3);
	waitstat4.attach(&t4);
	/*waitstat5.attach(&t5);
	waitstat6.attach(&t6);
	waitstat7.attach(&t7);
	waitstat8.attach(&t8);*/

	ntatstat1.attach(&t1);
	ntatstat2.attach(&t2);
	ntatstat3.attach(&t3);
	ntatstat4.attach(&t4);
	/*ntatstat5.attach(&t5);
	ntatstat6.attach(&t6);
	ntatstat7.attach(&t7);
	ntatstat8.attach(&t8);*/

	servicestat1.attach(&t1);
	servicestat2.attach(&t2);
	servicestat3.attach(&t3);
	servicestat4.attach(&t4);
	/*servicestat5.attach(&t5);
	servicestat6.attach(&t6);
	servicestat7.attach(&t7);
	servicestat8.attach(&t8);*/

	cout<<endl<<"\n\n\tFor how many ticks would you like the simulation to run?   ";
	int sml;
	cin>>sml;


	Simulation::run(sml);

	cout << "\n\n\t\t\tTASK A **********           ";
	cout << "\n\n\t\t\tMean Turn Around time (TAT) of Task 1:   " <<finishstat1.getValue();
	cout << "\n\n\t\t\tMean computation time of Task 1:   " <<servicestat1.getValue();
	cout << "\n\n\t\t\tMean NTA time of Task 1:   " <<ntatstat1.getValue();
	cout << "\n\n\t\t\tMean waiting time of Task 1:   " <<waitstat1.getValue()<<endl;

	cout << "\n\n\t\t\tTASK B **********            ";
	cout << "\n\n\t\t\tMean Turn Around time (TAT) of Task 2:   " <<finishstat2.getValue();
	cout << "\n\n\t\t\tMean computation time of Task 2:   " <<servicestat2.getValue();
	cout << "\n\n\t\t\tMean NTA time of Task 2:   " <<ntatstat2.getValue();
	cout << "\n\n\t\t\tMean waiting time of Task 2:   " <<waitstat2.getValue()<<endl;

	cout << "\n\n\t\t\tTASK C **********            ";
	cout << "\n\n\t\t\tMean Turn Around time (TAT) of Task 3:   " <<finishstat3.getValue();
	cout << "\n\n\t\t\tMean computation time of Task 3:   " <<servicestat3.getValue();
	cout << "\n\n\t\t\tMean NTA time of Task 3:   " <<ntatstat3.getValue();
	cout << "\n\n\t\t\tMean waiting time of Task 3:   " <<waitstat3.getValue()<<endl;

	cout << "\n\n\t\t\tTASK D **********           ";
	cout << "\n\n\t\t\tMean Turn Around time (TAT) of Task 4:   " <<finishstat4.getValue();
	cout << "\n\n\t\t\tMean computation time of Task 4:   " <<servicestat4.getValue();
	cout << "\n\n\t\t\tMean NTA time of Task 4:   " <<ntatstat4.getValue();
	cout << "\n\n\t\t\tMean waiting time of Task 4:   " <<waitstat4.getValue()<<endl;

	/*cout << "\n\n\t\t\tTASK E **********           ";
	cout << "\n\n\t\t\tMean Turn Around time (TAT) of Task 5:   " <<finishstat5.getValue();
	cout << "\n\n\t\t\tMean computation time of Task 5:   " <<servicestat5.getValue();
	cout << "\n\n\t\t\tMean NTA time of Task 5:   " <<ntatstat5.getValue();
	cout << "\n\n\t\t\tMean waiting time of Task 5:   " <<waitstat5.getValue()<<endl;

	cout << "\n\n\t\t\tTASK F **********            ";
	cout << "\n\n\t\t\tMean Turn Around time (TAT) of Task 6:   " <<finishstat2.getValue();
	cout << "\n\n\t\t\tMean computation time of Task 6:   " <<servicestat6.getValue();
	cout << "\n\n\t\t\tMean NTA time of Task 6:   " <<ntatstat6.getValue();
	cout << "\n\n\t\t\tMean waiting time of Task 6:   " <<waitstat6.getValue()<<endl;

	cout << "\n\n\t\t\tTASK G **********            ";
	cout << "\n\n\t\t\tMean Turn Around time (TAT) of Task 7:   " <<finishstat7.getValue();
	cout << "\n\n\t\t\tMean computation time of Task 7:   " <<servicestat7.getValue();
	cout << "\n\n\t\t\tMean NTA time of Task 7:   " <<ntatstat7.getValue();
	cout << "\n\n\t\t\tMean waiting time of Task 7:   " <<waitstat7.getValue()<<endl;

	cout << "\n\n\t\t\tTASK H **********           ";
	cout << "\n\n\t\t\tMean Turn Around time (TAT) of Task 8:   " <<finishstat8.getValue();
	cout << "\n\n\t\t\tMean computation time of Task 8:   " <<servicestat8.getValue();
	cout << "\n\n\t\t\tMean NTA time of Task 8:   " <<ntatstat8.getValue();
	cout << "\n\n\t\t\tMean waiting time of Task 8:   " <<waitstat8.getValue()<<endl;*/


  } catch (BaseExc &e) {
	cout << e.what() << endl;
  }

}

