/* server.c */

#include<sys/types.h>
#include<sys/socket.h>
#include<sys/stat.h>
#include<netinet/in.h>
#include<unistd.h>
#include<stdlib.h>
#include<stdio.h>
#include<dirent.h>
#include<fcntl.h>
#include<pthread.h>


void * handle_client(void *);
char verify_user(char * username, char * password, char * password_file);
void list_dir(int sd);
int read_file(char * file_name, int sd);
int write_file(char * file_name, int sd);

struct parameters
	{
	int socket;
	struct sockaddr_in address;
	char passwd_file[30];
        };


int main()
{
   int create_socket,new_socket, new_thread_socket,addrlen, n=0;
   int bufsize = 1024, i = 0, j = 0, fd;
   char ch = 0, *buffer = malloc(bufsize), c, config_type[20], port_no[10], password_file[30];
   struct sockaddr_in address_client, address_server, address_server2;
   pthread_t th;
   pthread_attr_t attr;
   struct parameters param;
   int sd[20] = {15001, 15002, 15003, 15004, 15005, 15006, 15007, 15008, 15009, 15010, 15011, 15012, 15013, 15014, 15015, 15016, 15017, 15018, 15019, 15020};
   int thread_no = 0;

//   printf("\x1B[2J");

   //Read the Configuration File
   printf("\nReading the Configuation File...\n\n");
   if( (fd = open("./config", O_RDONLY)) < 0 )
	{
	printf("\nNo Configuation File found !!\nExiting...\n");
	exit(-1);
        }
else
	{
	while(1)
		{
		if( read(fd, (void *) &ch, 1) <= 0)
			{
			break;
        		}
        	if(ch == '#')
			{
			while(ch != '\n')
			{
				if( read(fd, (char *) &ch, 1) <= 0)
					break;
        		}
			printf(".....Comment Line skipped.....\n");
        		}
		else if(ch == EOF)
			{
			printf(".....EOF found.....\n");
			break;
        		}
		else
			{
			i = 0;
			config_type[i++] = ch;
			while(ch != '=')
				{
				if( read(fd, (char *) &ch, 1) <= 0)
					break;
				config_type[i++] = ch;
        			}
			config_type[i-1] = '\0';

			i = 0;
			if(!strcmp(config_type, "PORT_NO"))
				{
				while(ch != '\n')
					{
					if (read(fd, (char *) &ch, 1) <= 0)
						break;
					port_no[i++] = ch;
        				}
				port_no[i-1] = '\0';
				printf(".....Port No = %s.....\n", port_no);
        			}
			else if (!strcmp(config_type, "PASSWORD_FILE"))
				{
				while(ch != '\n')
					{
					if( read(fd, (char *) &ch, 1) <= 0)
						break;
					password_file[i++] = ch;
        				}
				password_file[i-1] = '\0';
				printf(".....Password_File = %s.....\n", password_file);
        			}
			else
				{
				while(ch != '\n')
					{
					if( read(fd, (char *) &ch, 1) <= 0)
						break;
        				}
					printf(".....Line Ignored.....");
        			}
        		}
		i = 0;
		config_type[0] = '\0';
        	}
	close(fd);
        }

   printf("\n\nFinished with the Configuation File !!\n\n");

   if ((create_socket = socket(AF_INET,SOCK_STREAM,0)) > 0)
     printf("\n\nThe socket was created\n");

   address_server.sin_family = AF_INET;
   address_server.sin_addr.s_addr = htonl(INADDR_ANY);
   address_server.sin_port = htons(atoi(port_no));

   if (bind(create_socket,(struct sockaddr *)&address_server,sizeof(address_server)) == 0)
     printf("Binding Socket\n");
   else
        {
	printf("\nBinding Failed...\n");
	exit(-1);
        }


	   listen(create_socket,3);
	     printf("Listen on the Socket...\n");

	   addrlen = sizeof(struct sockaddr_in);
	   thread_no = 0;

		while(1)
		{
		  printf("Waiting for a new conection....\n");
		  if((new_socket = accept(create_socket,(struct sockaddr *)&address_client,&addrlen)) > 0)
			printf("Accept - accepting a new connection....\n");
		  else
			{		
			printf("Accept Failed....\n");
			exit(-1);
			}
		   if (new_socket > 0)
		   {
		      printf("The Client %s is connected...\n",inet_ntoa(address_client.sin_addr));
		
//		      for(cont=1;cont<5000;cont++)
//			printf("\x7");
		   }
		   if((new_thread_socket = socket(AF_INET, SOCK_STREAM, 0)) < 0)
			printf("\nsocket error...\n");
		   address_server2 = address_server;
   		   address_server2.sin_port = htons(sd[thread_no]);
   		   if(bind(new_thread_socket, (struct sockaddr *)&address_server2,sizeof(address_server2))<0)
			printf("\n failed on bind\n ");	
		      printf("Port no %d\n",ntohs(address_server2.sin_port));

		   n = send(new_socket, (void *)&(address_server2.sin_port), sizeof(address_server2.sin_port), 0);
			printf("\n n = %d \n ", n);	
			sleep(1);
		  shutdown(new_socket,SHUT_RDWR);


		   //connect(new_thread_socket, (struct sockaddr *)&address_client, sizeof(address_client));

		   pthread_attr_init(&attr);
		   pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
		   param.socket = new_thread_socket;
		   param.address = address_client;
		   strcpy(&(param.passwd_file),password_file);
		   pthread_create(&th, &attr, handle_client, (void *)&param);
//		   handle_client(new_thread_socket, address_client);

		   thread_no = (thread_no + 1) % 20;
		   }
   shutdown(create_socket,SHUT_RDWR);
   return 0;
}
		   
void * handle_client(void *args)
{		
   int cont,server_socket, new_socket, addrlen;
   int bufsize = 1024, i = 0, j = 0, error = 0, quit = 0, phase = 0, match = 0, fd;
   struct sockaddr_in address_client;
   char username[30] = "", password[30] = "", file[30] = "", access = 0, ch = 0;
   char *buffer = malloc(bufsize), c, config_type[20], port_no[10], passwd_file[30];
   struct parameters *p;

		printf("\niI was here...\n");

   p = (struct parameters *)args;
   server_socket = p->socket;
   address_client = p->address;
   strcpy(passwd_file,p->passwd_file);

	   if(listen(server_socket,10) < 0)
		printf("\nListen Failed...\n");
	   addrlen = sizeof(struct sockaddr_in);
		printf("\nListen starting...\n");
           if((new_socket = accept(server_socket,(struct sockaddr *)&address_client,&addrlen)) < 0)
		printf("\nAccept Failed...\n");
		printf("\nListen Ending...\n");

		   phase = 0;
		   quit = 0;

			do
			{
			 buffer[0] = '\0';
			 printf("server - before recv %s\n",buffer);
			 if (recv(new_socket,buffer,bufsize,0) <= 0)
				{
				printf("Recv on client failed.....breaking out\n");
				break;
				}

			 printf("Message recieved: %s\n",buffer);
		
			    error=0;
			    i=0;
			    j=0;
			    c=buffer[0];   
			    i++;
		
			    switch(c) 
			    {
				case 'u':	if (phase == 0)
						{
						while(buffer[i++])
				// USERNAME
							{
							if(i==1)
								if (buffer[i] != ' ')
								{
									error = 1;
									break;
								}
								else
									i++;
		
							username[i-2] = buffer[i];
							}
						send(new_socket,"<SUC>",6,0);	
						phase++; 
						}
						else
						{
						error = 1;
						printf("Cant supply username at this point....");
						}
						break;
		
				case 'p':  	
				// PASSWORD	
						if (phase == 1)
						{
						while(buffer[i++])
							{
							if(i==1)
								if (buffer[i] != ' ')
								{
									error = 1;
									break;
								}
								else
									i++;
		
							password[i-2] = buffer[i];
							}
							printf("\ncalling verify_user....\n");
							if( (access = verify_user(username, password, passwd_file)) )
								{	
							printf("\nverify_user verified....\n");
								send(new_socket,"<SUC>",6,0);	
								phase++; 
								}
							else
								{	
								printf("\nverify_user failed....\n");
								error = 1;
								phase = 0;
								}
						}
						else
						{
						error = 1;
						printf("Password Mismatch OR Cant supply Password at this point....");
						}
						break;
		
				case 'l':	if (phase > 1)
				// LIST		
						{
						if (strcmp(&buffer[1], "<EOC>"))
							{
							error = 1;
							printf("Invalid Command Sequence....\n");
							break;
							}
						send(new_socket,"<SUC>",6,0);
						getc(stdin);
						list_dir(new_socket);
						}
						else
						{
						error = 1;
						printf("First you need to get authenticated....\n");
						}
						break;

				case 'r':       if (phase > 1)
				// READ		
						{
						i = 0;
						j = 0;
						match = 0;
						i++;
						if (buffer[i] != ' ')
							{
							error = 1;
							break;
							}
						else
							{
							i = 2;
							while(buffer[i] != '\0')
								{
								printf("\n");
								printf("%d - %c\n",i, buffer[i]);
								file[i-2] = buffer[i];
								i++;
								}
								file[i-2] = '\0';

							if(strncmp(&buffer[i+1], "<EOC>",5))
								{
								error = 1;
								break;
								}
								
						/*while(1)
							{
							if(buffer[i] == '<')
								if(buffer[i+1] == 'E')
									if(buffer[i+2] == 'O')
										if(buffer[i+3] == 'C')
											if(buffer[i+4] == '>')
												{
												match = 1;
												break;
												}
							else if (match != 1 && buffer[i] == '\0')
								{
								recv(new_socket, buffer, 50, 0);
								i = 0;
								j++;
								}
							else
								file[j++] = buffer[i++];
							}
	
							if (match != 1)
		                                                {
		                                                        error = 1;
		                                                        break;
		                                                }
							else	
		                                                {
								send(new_socket, "<SUC>", 6, 0);
								file[j]='\0';
								read_file(file,new_socket);
		                                                }*/
	/*			         	while(buffer[i++])
		                                {
		                                        if(i==1)
		                                                if (buffer[i] != ' ')
		                                                {
		                                                        error = 1;
		                                                        break;
		                                                }
		                                                else
		                                                {
		                                                        i++;
		                                                }
		
							if (buffer[i] != ' ')
		                                        	file[j++] = buffer[i];
							else
								{
									file[j]='\0';
									read_file(file,new_socket);
									i++;
									j = 0;
								}
								if (buffer[i+1] == '\0')
								{
								file[j+1]='\0';
								read_file(file,new_socket);
								}
							}
	*/
							if(read_file(file,new_socket) == -1)
								{
								printf(".....read_file returned error.....\n");
								error = 1;
								break;
								}
							}
						}
						else
						{
						error = 1;
						printf("First you need to get authenticated....\n");
						}
					break; 

			case 'w':       
			// WRITE	
				if (access == 's')
						{
					if (phase > 1)
					{
					i = 0;
					j = 0;
					match = 0;
					i++;
	                                if (buffer[i] != ' ')
	                                	{
						getc(stdin);
	                                	error = 1;
	                                	break;
	                                	}
	                                else
						{
						getc(stdin);
						i = 2;
						while(1)
							{
							getc(stdin);
							if(buffer[i] == '<')
								if(buffer[i+1] == 'E')
									if(buffer[i+2] == 'O')
										if(buffer[i+3] == 'C')
											if(buffer[i+4] == '>')
												{
						getc(stdin);
												match = 1;
												break;
												}
								getc(stdin);
								file[j++] = buffer[i++];
							}
	
							if (match != 1)
		                                                {
								getc(stdin);
		                                                        error = 1;
		                                                        break;
		                                                }
							else	
		                                                {
								getc(stdin);
								file[j]='\0';
								if(write_file(file,new_socket) < 0)
									{
									error=1;
									break;
		                                                	}
		                                                }
	/*			         	while(buffer[i++])
		                                {
		                                        if(i==1)
		                                                if (buffer[i] != ' ')
		                                                {
		                                                        error = 1;
		                                                        break;
		                                                }
		                                                else
		                                                {
		                                                        i++;
		                                                }
		
							if (buffer[i] != ' ')
		                                        	file[j++] = buffer[i];
							else
								{
									file[j]='\0';
									write_file(file,new_socket);
									i++;
									j = 0;
								}
								if (buffer[i+1] == '\0')
								{
								file[j+1]='\0';
								write_file(file,new_socket);
								}
							}
	*/
							}
						}
						else
						{
						error = 1;
						printf("First you need to get authenticated....\n");
						}
						}
					else
						{
						error = 1;
						printf("Only Special Users are allowed to write Files ....\n");
						}
					break; 

			case 'q':
			// QUIT
					if (!strcmp(&buffer[1], "<EOC>"))
						{
						error = 1;
						printf("Invalid Command Sequence....\n");
						break;
						}
					shutdown(new_socket, SHUT_RDWR);
					//close(new_socket);
					quit = 1;
					break;

			    }	// End of SWITCH

		    if (error)
			{
	    		strcpy(buffer,"<ERR>");
       	    		send(new_socket,buffer,6,0);		 	
			}

		}
		while(!quit); //user 'q' to quit
	shutdown(new_socket, SHUT_RDWR);
}




	char verify_user(char * username, char * password, char * password_file)
	{
	int fd_passwd = 0, field = 0, i = 0, authenticated = 0, ch=0;
	char access, user[30], pass[30];

		printf("\nFile name %s...\n",password_file);
	if ( (fd_passwd = open(password_file, O_RDONLY)) == -1)
		{
		perror("Error in opening file ");
		printf("\nOpening of passwd file failed...\n");
		return 0;
		}
	read(fd_passwd, (void *)&ch, 1);
	while (ch != EOF)
		{
		if (field == 0)
			{
			if (ch != ' ')
			{
			user[i++] = ch;
			}
			}
		if (field == 1)
			{
			if (ch != ' ')
			{
			pass[i++] = ch;
			}
			}
		if (field == 2 && authenticated)
			{
			if (ch != '\n')
			{
			access = ch;
			printf("\nAccess Right for the User - %c\n", access);
			return (char)ch;
			}
			}
		if (ch == ' ')
			{
			field ++;
			if (field == 1)
				user[i] = '\0';
			if (field == 2)
				{
				pass[i] = '\0';
				if (!strcmp(user, username) && !strcmp(pass, password))
					authenticated = 1;
				}
			i = 0;
			}
		if (ch == '\n')
			{
			field = 0;
			i = 0;
			user[0] = '\0';
			pass[0] = '\0';
			}
		if(read(fd_passwd, (void *)&ch, 1) <= 0)
			{
			printf(" Read Failed.... ");
			break;
			}
		printf("\n");
		}
	return 0;
	}



	void list_dir(int sd)
	{	
	int j = 0;
	char * dir_name, buf[50];
	DIR * dir;
	struct dirent * dent;
	dir_name = get_current_dir_name();
	dir = opendir(dir_name);

	printf("Directory Listing....\n");
	printf("DIR/FILE NAME \t TYPE\n");
	while( dent = readdir(dir) )
		{
		//printf("%s\n", dent->d_name);
		if( ( j + strlen(dent->d_name) + 2 ) < 50 )
			{
			strcpy(&buf[j],dent->d_name) ;
			j += strlen(dent->d_name);
			buf[j++] = '\n';
			}
		else
			{
			buf[j] = '\0';
			printf("Packet ----->");
			printf("%s", buf);
			send(sd, buf, j, 0);
			j = 0;
			strcpy(&buf[j],dent->d_name) ;
			j += strlen(dent->d_name);
			buf[j++] = '\n';
			}
		}
	buf[j] = '\0';
	printf("Last Packet");
	printf("%s\n", buf);
	send(sd, buf, j, 0);
	send(sd,"<EOF>",6,0);
	getc(stdin);
	}
	
	
	
	
	int read_file(char * file_name, int sd)
	{
	int fd,n;
	char buffer[50];


	if( (fd = open(file_name,O_RDONLY)) < 0)
		{
		printf("\nError while opening file - %s in read_file\n", file_name);
		return -1;
		}
	send(sd, "<SUC>", 6, 0);
	while(1)
		{
		if( (n = read(fd,buffer,50)) < 0)
			{
			printf("\nRead failed....\n");
			return -1;
			}
		send(sd,buffer,n,0);
		if (n < 50)
			{
			break;
			}
		}	
	send(sd,"<EOF>",6,0);
	close(fd);
	return 0;
	}
	
	


	int write_file(char * file_name, int sd)
	{
	int fd, n, match=0, found=0, j=0, pos=0;
        char buffer[50], temp[6];

	printf(".....write_file.....");
	if( (fd = open(file_name,O_CREAT | O_TRUNC | O_RDWR)) < 0 )
                {
		printf("\nError opening the file - %s\n", file_name);
		return -1;
		}
	
	send(sd, "<SUC>", 6, 0);
        
	while(1)
                {

		n = recv(sd, buffer, 50, 0);

		if(match == 1)
			{ 
			for(j=pos; j<6; j++)
				temp[j] = buffer[j-pos];
			if(strcmp(temp, "<EOF>"))
				{
				match = 0;
				pos = 0;
				}
			else
				{
				found = 1;
				break;
				}
			}
		for(j=0;j<n;j++)
		{ 
		if(buffer[j] == '<')
		{ 
			strncpy(temp, &buffer[j], n-j);
			if((n-j) < 6)
				{
				match = 1;
				pos = n-j;
				}
			else if(!strcmp(temp, "<EOF>"))
					{
					found = 1;
					match = 0;
					}
		}
		}
		if(match)
			{
			write(fd,buffer,n-pos);
			printf("\nMATCH CASE\n");
			break;
			}
		else if (found && !pos)
			{
			write(fd,buffer,n-6);
			printf("\nFOUND CASE\n");
			break;
			}
		else
			write(fd, buffer, n);
                }
	close(fd);
	}


