/*
 * File: Veicolo0.c
 *
 * Real-Time Workshop code generated for Simulink model Veicolo0.
 *
 * Model version                        : 1.0
 * Real-Time Workshop file version      : 6.1  (R14SP1)  05-Sep-2004
 * Real-Time Workshop file generated on : Mon May 23 15:36:16 2005
 * TLC version                          : 6.1 (Aug 24 2004)
 * C source code generated on           : Mon May 23 15:36:16 2005
 *
 * You can customize this banner by specifying a different template.
 */

#include "Veicolo0.h"
#include "Veicolo0_private.h"

uint8_T _sfEvent_Veicolo0_;

/* Block signals (auto storage) */
BlockIO_Veicolo0 Veicolo0_B;

/* Continuous states */
ContinuousStates_Veicolo0 Veicolo0_X;

/* Solver Matrices */

/* A and B matrices used by ODE5 fixed-step solver */
static const real_T rt_ODE5_A[6] = {
  1.0/5.0, 3.0/10.0, 4.0/5.0, 8.0/9.0, 1.0, 1.0
};
static const real_T rt_ODE5_B[6][6] = {
  {1.0/5.0, 0.0, 0.0, 0.0, 0.0, 0.0},
  {3.0/40.0, 9.0/40.0, 0.0, 0.0, 0.0, 0.0},
  {44.0/45.0, -56.0/15.0, 32.0/9.0, 0.0, 0.0, 0.0},
  {19372.0/6561.0, -25360.0/2187.0, 64448.0/6561.0, -212.0/729.0, 0.0, 0.0},
  {9017.0/3168.0,-355.0/33.0,46732.0/5247.0,49.0/176.0,-5103.0/18656.0,0.0},
  {35.0/384.0, 0.0, 500.0/1113.0, 125.0/192.0, -2187.0/6784.0, 11.0/84.0}
};

/* Block states (auto storage) */
D_Work_Veicolo0 Veicolo0_DWork;

/* Previous zero-crossings (trigger) states */
PrevZCSigStates_Veicolo0 Veicolo0_PrevZC;

/* External inputs (root inport signals with auto storage) */
ExternalInputs_Veicolo0 Veicolo0_U;

/* External output (root outports fed by signals with auto storage) */
ExternalOutputs_Veicolo0 Veicolo0_Y;

/* Real-time model */
RT_MODEL_Veicolo0 Veicolo0_M_;
RT_MODEL_Veicolo0 *Veicolo0_M = &Veicolo0_M_;

/* This function implements a singletasking scheduler for a system with 2
 * rates.  This function is called by the generated step function, hence the
 * generated code self-manages all its subrates.
 */
static void rate_scheduler(void)
{

  /* Compute which subrates run during the next base time step.  Subrates
   * are an integer multiple of the base rate counter.  Therefore, the subtask
   * counter is reset when it reaches its limit (zero means run).
   */
}

/* This function updates continuous states using the ODE5 fixed-step
 * solver algorithm
 */
static void rt_ertODEUpdateContinuousStates(RTWSolverInfo *si , int_T tid)
{
  time_T t = rtsiGetT(si);
  time_T tnew = rtsiGetSolverStopTime(si);
  time_T h = rtsiGetStepSize(si);
  real_T *x = rtsiGetContStates(si);
  ODE5_IntgData *id = rtsiGetSolverData(si);
  real_T *y = id->y;
  real_T *f0 = id->f[0];
  real_T *f1 = id->f[1];
  real_T *f2 = id->f[2];
  real_T *f3 = id->f[3];
  real_T *f4 = id->f[4];
  real_T *f5 = id->f[5];
  real_T hB[6];
  int_T i;

  int_T nXc = 5;

  rtsiSetSimTimeStep(si,MINOR_TIME_STEP);

  /* Save the state values at time t in y, we'll use x as ynew. */
  (void)memcpy(y, x, nXc*sizeof(real_T));

  /* Assumes that rtsiSetT and ModelOutputs are up-to-date */
  /* f0 = f(t,y) */
  rtsiSetdX(si, f0);
  Veicolo0_derivatives();

  /* f(:,2) = feval(odefile, t + hA(1), y + f*hB(:,1), args(:)(*)); */
  hB[0] = h * rt_ODE5_B[0][0];
  for (i = 0; i < nXc; i++) {
    x[i] = y[i] + (f0[i]*hB[0]);
  }
  rtsiSetT(si, t + h*rt_ODE5_A[0]);
  rtsiSetdX(si, f1);
  Veicolo0_step(0);
  Veicolo0_derivatives();

  /* f(:,3) = feval(odefile, t + hA(2), y + f*hB(:,2), args(:)(*)); */
  for (i = 0; i <= 1; i++) hB[i] = h * rt_ODE5_B[1][i];
  for (i = 0; i < nXc; i++) {
    x[i] = y[i] + (f0[i]*hB[0] + f1[i]*hB[1]);
  }
  rtsiSetT(si, t + h*rt_ODE5_A[1]);
  rtsiSetdX(si, f2);
  Veicolo0_step(0);
  Veicolo0_derivatives();

  /* f(:,4) = feval(odefile, t + hA(3), y + f*hB(:,3), args(:)(*)); */
  for (i = 0; i <= 2; i++) hB[i] = h * rt_ODE5_B[2][i];
  for (i = 0; i < nXc; i++) {
    x[i] = y[i] + (f0[i]*hB[0] + f1[i]*hB[1] + f2[i]*hB[2]);
  }
  rtsiSetT(si, t + h*rt_ODE5_A[2]);
  rtsiSetdX(si, f3);
  Veicolo0_step(0);
  Veicolo0_derivatives();

  /* f(:,5) = feval(odefile, t + hA(4), y + f*hB(:,4), args(:)(*)); */
  for (i = 0; i <= 3; i++) hB[i] = h * rt_ODE5_B[3][i];
  for (i = 0; i < nXc; i++) {
    x[i] = y[i] + (f0[i]*hB[0] + f1[i]*hB[1] + f2[i]*hB[2] +
      f3[i]*hB[3]);
  }
  rtsiSetT(si, t + h*rt_ODE5_A[3]);
  rtsiSetdX(si, f4);
  Veicolo0_step(0);
  Veicolo0_derivatives();

  /* f(:,6) = feval(odefile, t + hA(5), y + f*hB(:,5), args(:)(*)); */
  for (i = 0; i <= 4; i++) hB[i] = h * rt_ODE5_B[4][i];
  for (i = 0; i < nXc; i++) {
    x[i] = y[i] + (f0[i]*hB[0] + f1[i]*hB[1] + f2[i]*hB[2] +
      f3[i]*hB[3] + f4[i]*hB[4]);
  }
  rtsiSetT(si, tnew);
  rtsiSetdX(si, f5);
  Veicolo0_step(0);
  Veicolo0_derivatives();

  /* tnew = t + hA(6);
     ynew = y + f*hB(:,6); */
  for (i = 0; i <= 5; i++) hB[i] = h * rt_ODE5_B[5][i];
  for (i = 0; i < nXc; i++) {
    x[i] = y[i] + (f0[i]*hB[0] + f1[i]*hB[1] + f2[i]*hB[2] +
      f3[i]*hB[3] + f4[i]*hB[4] + f5[i]*hB[5]);
  }

  rtsiSetSimTimeStep(si,MAJOR_TIME_STEP);
}

/* Functions for block: <S13>/Chart */

#define Veicolo0_event_trigger          (0)
#define Veicolo0_event_CLK_EXPIRE       (1)
#define Veicolo0_IN_s0                  (1)
#define Veicolo0_IN_s1                  (2)

static void Veicolo0_c1_Veicolo0(void );

static void Veicolo0_c1_Veicolo0(void )
{
  if(Veicolo0_DWork.Chart.is_active_c1_Veicolo0 == 0) {
    Veicolo0_DWork.Chart.is_active_c1_Veicolo0 = 1;
    Veicolo0_DWork.Chart.is_c1_Veicolo0 = (uint8_T)Veicolo0_IN_s0;
    Veicolo0_B.marcia_out = Veicolo0_U.Inport3;
  } else {
    switch(Veicolo0_DWork.Chart.is_c1_Veicolo0) {
     case Veicolo0_IN_s0:
      if(_sfEvent_Veicolo0_ == Veicolo0_event_trigger) {
        Veicolo0_DWork.Chart.is_c1_Veicolo0 = (uint8_T)Veicolo0_IN_s1;
        Veicolo0_B.marcia_out = 0.0;
      }
      break;
     case Veicolo0_IN_s1:
      if(_sfEvent_Veicolo0_ == Veicolo0_event_CLK_EXPIRE) {
        Veicolo0_DWork.Chart.is_c1_Veicolo0 = (uint8_T)Veicolo0_IN_s0;
        Veicolo0_B.marcia_out = Veicolo0_U.Inport3;
      }
      break;
    }
  }
}

/* Initial conditions for trigger system: '<S13>/Chart' */
void Veicolo0_Chart_Init(void)
{

  /* Initialize code for chart: <S13>/Chart */
  Veicolo0_DWork.Chart.is_active_c1_Veicolo0 = 0;
  Veicolo0_DWork.Chart.is_c1_Veicolo0 = 0;
  Veicolo0_B.marcia_out = 0.0;
}

/* Output and update for trigger system: '<S13>/Chart' */
void Veicolo0_Chart(void)
{

  /* local block i/o variables */

  int8_T rtb_inputevents[2];

  if (rtmIsMajorTimeStep(Veicolo0_M)) {
    ZCEventType trigEvent;
    ZCEventType zcEvents[2];

    /* subsystem trigger input */
    trigEvent = false;

    zcEvents[0] = rt_ZCFcn(ANY_ZERO_CROSSING,
     &(Veicolo0_PrevZC.sf_Chart_ZCE[0]),
     Veicolo0_B.HiddenBuf_InsertedFor_Chart[0]);
    trigEvent |= zcEvents[0];

    zcEvents[1] = rt_ZCFcn(ANY_ZERO_CROSSING,
     &(Veicolo0_PrevZC.sf_Chart_ZCE[1]),
     Veicolo0_B.HiddenBuf_InsertedFor_Chart[1]);
    trigEvent |= zcEvents[1];
    /* conditionally execute */
    if (trigEvent) {

      /* update trigger block outputs */

      rtb_inputevents[0] = (int8_T) zcEvents[0];

      rtb_inputevents[1] = (int8_T) zcEvents[1];

      /* Stateflow: '<S13>/Chart' incorporates:
       *   Inport: '<Root>/Inport3'
       */

      {
        uint8_T b_previousEvent;
        if(rtb_inputevents[0] != 0) {
          b_previousEvent = _sfEvent_Veicolo0_;
          _sfEvent_Veicolo0_ = Veicolo0_event_trigger;
          Veicolo0_c1_Veicolo0();
          _sfEvent_Veicolo0_ = b_previousEvent;
        }
        if(rtb_inputevents[1] == 1) {
          b_previousEvent = _sfEvent_Veicolo0_;
          _sfEvent_Veicolo0_ = Veicolo0_event_CLK_EXPIRE;
          Veicolo0_c1_Veicolo0();
          _sfEvent_Veicolo0_ = b_previousEvent;
        }
      }
    }
  }
}

/* Model step function */
void Veicolo0_step(int_T tid)
{

  /* local block i/o variables */

  real_T rtb_Integrator;
  real_T rtb_Integrator_m;
  real_T rtb_Velocita;
  real_T rtb_Sum_p;
  real_T rtb_D4;
  real_T rtb_Rw;
  real_T rtb_Integrator_mc;
  real_T rtb_MultiportSwitch;
  real_T rtb_MultiportSwitch1;
  real_T rtb_MultiportSwitch2;
  real_T rtb_MultiportSwitch3;
  real_T rtb_Angoloditorsione;
  real_T rtb_Switch;
  real_T rtb_Switch_c;
  real_T rtb_Switch_b;

  /* Update absolute time of base rate at minor time step */
  if (rtmIsMinorTimeStep(Veicolo0_M)) {
    Veicolo0_M->Timing.t[0] = rtsiGetT(&Veicolo0_M->solverInfo);
  }

  if (rtmIsMajorTimeStep(Veicolo0_M)) {
    /* set solver stop time */
    rtsiSetSolverStopTime(&Veicolo0_M->solverInfo,
     ((Veicolo0_M->Timing.clockTick0+1)*Veicolo0_M->Timing.stepSize0));
  }                                     /* end MajorTimeStep */

  /* Integrator: '<S12>/Integrator' */
  rtb_Integrator = Veicolo0_X.Integrator_CSTATE;

  /* Outport: '<Root>/Outport4' */
  Veicolo0_Y.Outport4 = rtb_Integrator;

  /* Integrator: '<S11>/Integrator' */
  rtb_Integrator_m = Veicolo0_X.Integrator_i_CSTATE;

  /* Outport: '<Root>/Outport5' */
  Veicolo0_Y.Outport5 = rtb_Integrator_m;

  /* Integrator: '<S1>/Velocita'' */
  rtb_Velocita = Veicolo0_X.Velocita_CSTATE;

  /* Outport: '<Root>/Outport6' */
  Veicolo0_Y.Outport6 = rtb_Velocita;

  if (rtmIsMajorTimeStep(Veicolo0_M) &&
   Veicolo0_M->Timing.TaskCounters.TID[1] == 0) { /* Sample time: [0.001s, 0.0s] */

    /* Product: '<S16>/D' incorporates:
     *  Constant: '<S16>/bm2'
     *  Inport: '<Root>/Inport1'
     *  Constant: '<S16>/Fz'
     */
    Veicolo0_B.D = Veicolo0_U.Inport1 * Veicolo0_P.bm2_Value *
      Veicolo0_P.Fz_Value;

    /* Product: '<S15>/Divide' incorporates:
     *  Constant: '<S15>/C2'
     */
    Veicolo0_B.Divide = Veicolo0_P.C2_Value / Veicolo0_B.D;
  }

  /* Sum: '<S17>/Sum' incorporates:
   *  Product: '<S18>/Product'
   *  Sum: '<S18>/Sum'
   *  Product: '<S18>/Divide'
   *  Gain: '<S18>/Gain'
   *  Constant: '<S17>/C1'
   *  Constant: '<S18>/rw'
   */
  rtb_Sum_p = Veicolo0_P.C1_Value_a + (Veicolo0_P.rw_Value * rtb_Integrator -
    rtb_Velocita) / rtb_Velocita * Veicolo0_P.Gain_Gain;

  /* Product: '<S15>/D4' incorporates:
   *  Product: '<S15>/D5'
   *  Trigonometry: '<S15>/Trigonometric Function2'
   *  Constant: '<S15>/C1'
   */
  rtb_D4 = Veicolo0_P.C1_Value * atan(Veicolo0_B.Divide * rtb_Sum_p);

  if (rtmIsMajorTimeStep(Veicolo0_M) &&
   Veicolo0_M->Timing.TaskCounters.TID[1] == 0) { /* Sample time: [0.001s, 0.0s] */

    /* Product: '<S14>/D3' incorporates:
     *  Sum: '<S14>/Sum'
     *  Product: '<S14>/Divide1'
     *  Constant: '<S14>/B1'
     *  Constant: '<S14>/C1'
     *  Constant: '<S14>/C2'
     */
    Veicolo0_B.D3 = (Veicolo0_P.C1_Value_l - Veicolo0_P.C2_Value_g) *
      (Veicolo0_P.B1_Value / Veicolo0_B.D);
  }

  /* Gain: '<S9>/Rw' incorporates:
   *  Sum: '<S9>/Sum1'
   *  Trigonometry: '<S9>/Trigonometric Function1'
   *  Product: '<S9>/D1'
   *  Product: '<S9>/D2'
   *  Product: '<S9>/D3'
   *  Constant: '<S9>/C'
   *  Sum: '<S9>/Sum'
   *  Trigonometry: '<S9>/Trigonometric Function'
   *  Constant: '<S9>/C1'
   */
  rtb_Rw = ((sin(Veicolo0_P.C_Value * atan(rtb_D4 + rtb_Sum_p * Veicolo0_B.D3))
    * Veicolo0_B.D) + Veicolo0_P.C1_Value_n) * Veicolo0_P.Rw_Gain;

  /* Gain: '<S1>/Gain' */
  Veicolo0_B.Gain = rtb_Rw * Veicolo0_P.Gain_Gain_a;

  if (rtmIsMajorTimeStep(Veicolo0_M) &&
   Veicolo0_M->Timing.TaskCounters.TID[1] == 0) { /* Sample time: [0.001s, 0.0s] */

    /* Saturate: '<S1>/Saturation' incorporates:
     *  Inport: '<Root>/Inport2'
     */
    Veicolo0_B.Saturation = rt_SATURATE(Veicolo0_U.Inport2,
     Veicolo0_P.Saturation_LowerSat, Veicolo0_P.Saturation_UpperSat);

    /* DataTypeConversion: '<S13>/Data Type Conversion' incorporates:
     *  UnitDelay: '<S21>/Delay Input1'
     *  RelationalOperator: '<S21>/FixPt Relational Operator'
     *  Inport: '<Root>/Inport3'
     */
    Veicolo0_B.DataTypeConversion = (real_T)(Veicolo0_U.Inport3 !=
      Veicolo0_DWork.DelayInput1_DSTATE);
  }

  /* Integrator: '<S13>/Integrator' */
  if (rtmIsMajorTimeStep(Veicolo0_M)) {
    ZCEventType zcEvent;

    /* evaluate zero-crossings */
    zcEvent = rt_ZCFcn(ANY_ZERO_CROSSING, &Veicolo0_PrevZC.Integrator_a_ZCE,
     Veicolo0_B.DataTypeConversion);
    if (zcEvent) {
      Veicolo0_X.Integrator_a_CSTATE = Veicolo0_P.Integrator_IC_m;
    }
  }
  rtb_Integrator_mc = Veicolo0_X.Integrator_a_CSTATE;

  /* SignalConversion: '<S13>/HiddenBuf_InsertedFor_Chart' incorporates:
   *  RelationalOperator: '<S20>/Compare'
   *  DataTypeConversion: '<S13>/Data Type Conversion1'
   *  Constant: '<S20>/Constant'
   */
  Veicolo0_B.HiddenBuf_InsertedFor_Chart[0] = Veicolo0_B.DataTypeConversion;
  Veicolo0_B.HiddenBuf_InsertedFor_Chart[1] = (real_T)(rtb_Integrator_mc >=
    Veicolo0_P.Constant_Value_b);

  /* Stateflow: '<S13>/Chart' */
  /* trigger Stateflow Block: <S13>/Chart */

  if (rtmIsMajorTimeStep(Veicolo0_M) &&
   Veicolo0_M->Timing.TaskCounters.TID[1] == 0) {

    Veicolo0_Chart();
  }

  Veicolo0_B.RateTransition = Veicolo0_B.marcia_out;

  /* MultiPortSwitch: '<S8>/Multiport Switch' incorporates:
   *  Constant: '<S8>/Constant4'
   *  Constant: '<S8>/Constant1'
   *  Constant: '<S8>/Constant'
   *  Constant: '<S8>/Constant2'
   *  Constant: '<S8>/Constant3'
   */
  switch((int32_T)Veicolo0_B.RateTransition) {
   case 0:
    rtb_MultiportSwitch = Veicolo0_P.Constant_Value;
    break;
   case 1:
    rtb_MultiportSwitch = Veicolo0_P.Constant1_Value;
    break;
   case 2:
    rtb_MultiportSwitch = Veicolo0_P.Constant2_Value;
    break;
   case 3:
    rtb_MultiportSwitch = Veicolo0_P.Constant3_Value;
    break;
   case 4:
    rtb_MultiportSwitch = Veicolo0_P.Constant4_Value;
    break;
  }

  /* MultiPortSwitch: '<S8>/Multiport Switch1' incorporates:
   *  Constant: '<S8>/Constant6'
   *  Constant: '<S8>/Constant7'
   *  Constant: '<S8>/Constant10'
   *  Constant: '<S8>/Constant8'
   *  Constant: '<S8>/Constant9'
   */
  switch((int32_T)Veicolo0_B.RateTransition) {
   case 0:
    rtb_MultiportSwitch1 = Veicolo0_P.Constant10_Value;
    break;
   case 1:
    rtb_MultiportSwitch1 = Veicolo0_P.Constant6_Value;
    break;
   case 2:
    rtb_MultiportSwitch1 = Veicolo0_P.Constant7_Value;
    break;
   case 3:
    rtb_MultiportSwitch1 = Veicolo0_P.Constant8_Value;
    break;
   case 4:
    rtb_MultiportSwitch1 = Veicolo0_P.Constant9_Value;
    break;
  }

  /* MultiPortSwitch: '<S8>/Multiport Switch2' incorporates:
   *  Constant: '<S8>/Constant5'
   *  Constant: '<S8>/Constant11'
   *  Constant: '<S8>/Constant13'
   *  Constant: '<S8>/Constant14'
   *  Constant: '<S8>/Constant12'
   */
  switch((int32_T)Veicolo0_B.RateTransition) {
   case 0:
    rtb_MultiportSwitch2 = Veicolo0_P.Constant5_Value;
    break;
   case 1:
    rtb_MultiportSwitch2 = Veicolo0_P.Constant11_Value;
    break;
   case 2:
    rtb_MultiportSwitch2 = Veicolo0_P.Constant12_Value;
    break;
   case 3:
    rtb_MultiportSwitch2 = Veicolo0_P.Constant13_Value;
    break;
   case 4:
    rtb_MultiportSwitch2 = Veicolo0_P.Constant14_Value;
    break;
  }

  /* MultiPortSwitch: '<S8>/Multiport Switch3' incorporates:
   *  Constant: '<S8>/Constant16'
   *  Constant: '<S8>/Constant17'
   *  Constant: '<S8>/Constant18'
   *  Constant: '<S8>/Constant15'
   *  Constant: '<S8>/Constant19'
   */
  switch((int32_T)Veicolo0_B.RateTransition) {
   case 0:
    rtb_MultiportSwitch3 = Veicolo0_P.Constant15_Value;
    break;
   case 1:
    rtb_MultiportSwitch3 = Veicolo0_P.Constant16_Value;
    break;
   case 2:
    rtb_MultiportSwitch3 = Veicolo0_P.Constant17_Value;
    break;
   case 3:
    rtb_MultiportSwitch3 = Veicolo0_P.Constant18_Value;
    break;
   case 4:
    rtb_MultiportSwitch3 = Veicolo0_P.Constant19_Value;
    break;
  }

  /* Integrator: '<S10>/Angolo di torsione' */
  rtb_Angoloditorsione = Veicolo0_X.Angoloditorsione_CSTATE;

  /* Switch: '<S10>/Switch' incorporates:
   *  Constant: '<S10>/Constant'
   */
  if(rtb_MultiportSwitch >= Veicolo0_P.Switch_Threshold) {
    rtb_Switch = rtb_Angoloditorsione;
  } else {
    rtb_Switch = Veicolo0_P.Constant_Value_c;
  }

  /* Switch: '<S10>/Switch1' incorporates:
   *  Product: '<S10>/Divide'
   *  Sum: '<S10>/Sum'
   *  Constant: '<S10>/Constant'
   */
  if(rtb_MultiportSwitch >= Veicolo0_P.Switch1_Threshold) {
    Veicolo0_B.Switch1 = rtb_Integrator_m - rtb_Integrator / rtb_MultiportSwitch;
  } else {
    Veicolo0_B.Switch1 = Veicolo0_P.Constant_Value_c;
  }

  /* Switch: '<S11>/Switch' incorporates:
   *  Product: '<S11>/1//taui'
   *  Sum: '<S11>/Sum1'
   *  Product: '<S11>/bi1'
   *  Product: '<S11>/+ki'
   *  Sum: '<S11>/Sum2'
   *  Constant: '<S11>/Constant'
   */
  if(rtb_MultiportSwitch >= Veicolo0_P.Switch_Threshold_i) {
    rtb_Switch_c = (rtb_Integrator_m - rtb_Integrator / rtb_MultiportSwitch) *
      rtb_MultiportSwitch1 + rtb_Switch * rtb_MultiportSwitch2;
  } else {
    rtb_Switch_c = Veicolo0_P.Constant_Value_n;
  }

  /* Gain: '<S11>/1//je' incorporates:
   *  Sum: '<S11>/Sum'
   *  Gain: '<S11>/Be'
   */
  Veicolo0_B.je = ((Veicolo0_B.Saturation - (rtb_Integrator_m *
    Veicolo0_P.Be_Gain)) - rtb_Switch_c) * Veicolo0_P.je_Gain;

  /* Switch: '<S12>/Switch' incorporates:
   *  Product: '<S12>/omegaw*bi//taui'
   *  Product: '<S12>/Product1'
   *  Product: '<S12>/Product'
   *  Sum: '<S12>/Sum1'
   *  Product: '<S12>/1//taui'
   *  Constant: '<S12>/Constant'
   */
  if(rtb_MultiportSwitch >= Veicolo0_P.Switch_Threshold_k) {
    rtb_Switch_b = ((rtb_Switch * rtb_MultiportSwitch2 + rtb_Integrator_m *
      rtb_MultiportSwitch1) - rtb_Integrator * rtb_MultiportSwitch1 /
      rtb_MultiportSwitch) / rtb_MultiportSwitch;
  } else {
    rtb_Switch_b = Veicolo0_P.Constant_Value_o;
  }

  /* Gain: '<S12>/1//jw' incorporates:
   *  Product: '<S12>/Product2'
   *  Sum: '<S12>/Sum' */
  Veicolo0_B.jw = ((rtb_Switch_b - rtb_Integrator * rtb_MultiportSwitch3) -
    rtb_Rw) * Veicolo0_P.jw_Gain;

  if (rtmIsMajorTimeStep(Veicolo0_M)) {
    if (rtmIsMajorTimeStep(Veicolo0_M) &&
     Veicolo0_M->Timing.TaskCounters.TID[1] == 0) { /* Sample time: [0.001s, 0.0s] */

      /* Update for UnitDelay: '<S21>/Delay Input1' */
      Veicolo0_DWork.DelayInput1_DSTATE = Veicolo0_U.Inport3;
    }
  }                                     /* end MajorTimeStep */

  if (rtmIsMajorTimeStep(Veicolo0_M)) {

    /* signal main to stop simulation */
    {                                   /* Sample time: [0.0s, 0.0s] */
      if ( (rtmGetTFinal(Veicolo0_M)!=-1) &&
       !((rtmGetTFinal(Veicolo0_M)-((Veicolo0_M->Timing.clockTick1 +
           Veicolo0_M->Timing.clockTickH1* 4294967296.0)) * 0.001 ) >
        ((Veicolo0_M->Timing.clockTick1 + Veicolo0_M->Timing.clockTickH1*
          4294967296.0)) * 0.001 *DBL_EPSILON)) {
        rtmSetErrorStatus(Veicolo0_M, "Simulation finished");
      }
    }

    if (rtmIsMajorTimeStep(Veicolo0_M)) {
      rt_ertODEUpdateContinuousStates(&Veicolo0_M->solverInfo, 0);
    }

    /* Update absolute time for base rate */

    if(!(++Veicolo0_M->Timing.clockTick0)) ++Veicolo0_M->Timing.clockTickH0;
    Veicolo0_M->Timing.t[0] = Veicolo0_M->Timing.clockTick0 *
      Veicolo0_M->Timing.stepSize0 + Veicolo0_M->Timing.clockTickH0 *
      Veicolo0_M->Timing.stepSize0 * 4294967296.0;

    if (rtmIsMajorTimeStep(Veicolo0_M) &&
     Veicolo0_M->Timing.TaskCounters.TID[1] == 0) {
      /* Update absolute timer for sample time: [0.001s, 0.0s] */

      Veicolo0_M->Timing.clockTick1++;
      if (!Veicolo0_M->Timing.clockTick1) Veicolo0_M->Timing.clockTickH1++;
    }

    rate_scheduler();
  }                                     /* end MajorTimeStep */
}

/* Derivatives for root system: '<Root>' */
void Veicolo0_derivatives(void)
{
  /* simstruct variables */
  StateDerivatives_Veicolo0 *Veicolo0_Xdot = (StateDerivatives_Veicolo0*)
    Veicolo0_M->ModelData.derivs;

  /* Integrator Block: <S12>/Integrator */
  {

    Veicolo0_Xdot->Integrator_CSTATE = Veicolo0_B.jw;
  }

  /* Integrator Block: <S11>/Integrator */
  {

    Veicolo0_Xdot->Integrator_i_CSTATE = Veicolo0_B.je;
  }

  /* Integrator Block: <S1>/Velocita' */
  {

    Veicolo0_Xdot->Velocita_CSTATE = Veicolo0_B.Gain;
  }

  /* Integrator Block: <S13>/Integrator */
  {

    Veicolo0_Xdot->Integrator_a_CSTATE = Veicolo0_P.Constant_Value_m;
  }

  /* Integrator Block: <S10>/Angolo di torsione */
  {

    Veicolo0_Xdot->Angoloditorsione_CSTATE = Veicolo0_B.Switch1;
  }
}

/* Model initialize function */
void Veicolo0_initialize(boolean_T firstTime)
{

  if (firstTime) {
    /* registration code */
    /* initialize real-time model */
    (void)memset((char_T *)Veicolo0_M, 0, sizeof(RT_MODEL_Veicolo0));

    {
      /* Setup solver object */

      rtsiSetSimTimeStepPtr(&Veicolo0_M->solverInfo,
       &Veicolo0_M->Timing.simTimeStep);
      rtsiSetTPtr(&Veicolo0_M->solverInfo, &rtmGetTPtr(Veicolo0_M));
      rtsiSetStepSizePtr(&Veicolo0_M->solverInfo, &Veicolo0_M->Timing.stepSize0);
      rtsiSetdXPtr(&Veicolo0_M->solverInfo, &Veicolo0_M->ModelData.derivs);
      rtsiSetContStatesPtr(&Veicolo0_M->solverInfo,
       &Veicolo0_M->ModelData.contStates);
      rtsiSetNumContStatesPtr(&Veicolo0_M->solverInfo,
       &Veicolo0_M->Sizes.numContStates);
      rtsiSetErrorStatusPtr(&Veicolo0_M->solverInfo,
       &rtmGetErrorStatus(Veicolo0_M));

      rtsiSetRTModelPtr(&Veicolo0_M->solverInfo, Veicolo0_M);
    }
    rtsiSetSimTimeStep(&Veicolo0_M->solverInfo, MAJOR_TIME_STEP);
    Veicolo0_M->ModelData.intgData.y = Veicolo0_M->ModelData.odeY;
    Veicolo0_M->ModelData.intgData.f[0] = Veicolo0_M->ModelData.odeF[0];
    Veicolo0_M->ModelData.intgData.f[1] = Veicolo0_M->ModelData.odeF[1];
    Veicolo0_M->ModelData.intgData.f[2] = Veicolo0_M->ModelData.odeF[2];
    Veicolo0_M->ModelData.intgData.f[3] = Veicolo0_M->ModelData.odeF[3];
    Veicolo0_M->ModelData.intgData.f[4] = Veicolo0_M->ModelData.odeF[4];
    Veicolo0_M->ModelData.intgData.f[5] = Veicolo0_M->ModelData.odeF[5];
    Veicolo0_M->ModelData.contStates = ((real_T *) &Veicolo0_X);
    rtsiSetSolverData(&Veicolo0_M->solverInfo, (void
      *)&Veicolo0_M->ModelData.intgData);
    rtsiSetSolverName(&Veicolo0_M->solverInfo,"ode5");

    rtmSetTPtr(Veicolo0_M, &Veicolo0_M->Timing.tArray[0]);

    rtmSetTFinal(Veicolo0_M, 0.02);
    Veicolo0_M->Timing.stepSize0 = 0.001;

    {
      /* block I/O */
      void *b = (void *) &Veicolo0_B;

      {

        int_T i;
        b = &Veicolo0_B.D;
        for (i = 0; i < 12; i++) {
          ((real_T*)b)[i] = 0.0;
        }
        b =&Veicolo0_B.marcia_out;
        for (i = 0; i < 1; i++) {
          ((real_T*)b)[i] = 0.0;
        }
      }
    }
    /* states */
    {
      real_T *x = (real_T *) &Veicolo0_X;
      (void)memset((char_T *)x, 0, sizeof(ContinuousStates_Veicolo0));
    }

    /* data type work */
    (void)memset((char_T *) &Veicolo0_DWork, 0, sizeof(D_Work_Veicolo0));
    Veicolo0_DWork.DelayInput1_DSTATE = 0.0;

    /* external inputs */
    Veicolo0_U.Inport1 = 0.0;
    Veicolo0_U.Inport2 = 0.0;
    Veicolo0_U.Inport3 = 0.0;

    /* external outputs */
    Veicolo0_Y.Outport4 = 0.0;
    Veicolo0_Y.Outport5 = 0.0;
    Veicolo0_Y.Outport6 = 0.0;
  }

  /* Zero-crossing state initialization */
  Veicolo0_PrevZC.Integrator_a_ZCE = UNINITIALIZED_ZCSIG;
  Veicolo0_PrevZC.sf_Chart_ZCE[0] = UNINITIALIZED_ZCSIG;
  Veicolo0_PrevZC.sf_Chart_ZCE[1] = UNINITIALIZED_ZCSIG;

  /* Integrator Block: <S12>/Integrator */
  Veicolo0_X.Integrator_CSTATE = Veicolo0_P.Integrator_IC;

  /* Integrator Block: <S11>/Integrator */
  Veicolo0_X.Integrator_i_CSTATE = Veicolo0_P.Integrator_IC_p;

  /* Integrator Block: <S1>/Velocita' */
  Veicolo0_X.Velocita_CSTATE = Veicolo0_P.Velocita_IC;

  /* InitializeConditions for UnitDelay: '<S21>/Delay Input1' */
  Veicolo0_DWork.DelayInput1_DSTATE = Veicolo0_P.DelayInput1_X0;

  /* Integrator Block: <S13>/Integrator */
  Veicolo0_X.Integrator_a_CSTATE = Veicolo0_P.Integrator_IC_m;

  Veicolo0_Chart_Init();

  /* Integrator Block: <S10>/Angolo di torsione */
  Veicolo0_X.Angoloditorsione_CSTATE = Veicolo0_P.Angoloditorsione_IC;

  /* Machine initializer */
  _sfEvent_Veicolo0_ = CALL_EVENT;
}

/* Model terminate function */
void Veicolo0_terminate(void)
{
  /* (no terminate code required) */
}

/* File trailer for Real-Time Workshop generated code.
 *
 * You can customize this file trailer by specifying a different template.
 *
 * [EOF]
 */
