# Copyright 1994-2004 The MathWorks, Inc.
#
# File    : ert_unix.tmf   $Revision: 1.55.4.24 $
#
# Abstract:
#	Real-Time Workshop template makefile for building a UNIX-based
#	stand-alone embedded real-time version of Simulink model using
#	generated C code.
#
# 	This makefile attempts to conform to the guidelines specified in the
# 	IEEE Std 1003.2-1992 (POSIX) standard. It is designed to be used
#       with GNU Make which is located in matlabroot/rtw/bin.
#
# 	Note that this template is automatically customized by the Real-Time
#	Workshop build procedure to create "<model>.mk"
#
#       The following defines can be used to modify the behavior of the
#	build:
#	  OPT_OPTS       - Optimization options. Default is -O. To enable 
#                          debugging specify as OPT_OPTS=-g. 
#                          Because of optimization problems in IBM_RS, 
#                          default is no-optimization. 
#         CPP_OPTS       - C++ compiler options.	
#	  OPTS           - User specific compile options.
#	  USER_SRCS      - Additional user sources, such as files needed by
#			   S-functions.
#	  USER_INCLUDES  - Additional include paths
#			   (i.e. USER_INCLUDES="-Iwhere-ever -Iwhere-ever2")
#
#       This template makefile is designed to be used with a system target
#       file that contains 'rtwgensettings.BuildDirSuffix' see ert.tlc


#------------------------ Macros read by make_rtw ------------------------------
#
# The following macros are read by the Real-Time Workshop build procedure:
#
#  MAKECMD         - This is the command used to invoke the make utility
#  HOST            - What platform this template makefile is targeted for
#                    (i.e. PC or UNIX)
#  BUILD           - Invoke make from the Real-Time Workshop build procedure
#                    (yes/no)?
#  SYS_TARGET_FILE - Name of system target file.

MAKECMD         = make
HOST            = UNIX
BUILD           = yes
SYS_TARGET_FILE = any

#---------------------- Tokens expanded by make_rtw ----------------------------
#
# The following tokens, when wrapped with "|>" and "<|" are expanded by the
# Real-Time Workshop build procedure.
#
#  MODEL_NAME          - Name of the Simulink block diagram
#  MODEL_MODULES       - Any additional generated source modules
#  MAKEFILE_NAME       - Name of makefile created from template makefile <model>.mk
#  MATLAB_ROOT         - Path to were MATLAB is installed.
#  S_FUNCTIONS         - List of additional S-function modules.
#  S_FUNCTIONS_LIB     - List of S-functions libraries to link. 
#  NUMST               - Number of sample times
#  NCSTATES            - Number of continuous states
#  COMPUTER            - Computer type. See the MATLAB computer command.
#  BUILDARGS           - Options passed in at the command line.
#  MULTITASKING        - yes (1) or no (0): Is solver mode multitasking
#  INTEGER_CODE        - yes (1) or no (0): Is generated code purely integer
#  MAT_FILE            - yes (1) or no (0): Should mat file logging be done,
#                        if 0, the generated code runs indefinitely
#  EXT_MODE            - yes (1) or no (0): Build for external mode
#  TMW_EXTMODE_TESTING - yes (1) or no (0): Build ext_test.c for external mode
#                        testing.
#  EXTMODE_TRANSPORT   - Index of transport mechanism (e.g. tcpip, serial) for extmode
#  MULTI_INSTANCE_CODE - Is the generated code multi instantiable (1/0)?
#  ADD_MDL_NAME_TO_GLOBALS - Do we add the model name to global 
#                        identifiers (1/0)?
#  GEN_MDLREF_SFCN     - (1/0): are we generating model reference wrapper s-function
#  MODELREFS           - List of referenced models
#  EXTMODE_STATIC      - yes (1) or no (0): Use static instead of dynamic mem alloc.
#  EXTMODE_STATIC_SIZE - Size of static memory allocation buffer.
#  TGT_FCN_LIB         - Target Funtion library to use

MODEL                   = Veicolo0
MODULES                 = Veicolo0_data.c 
MAKEFILE                = Veicolo0.mk
MATLAB_ROOT             = /usr/local/matlab
ALT_MATLAB_ROOT         = /usr/local/matlab
S_FUNCTIONS             = 
S_FUNCTIONS_LIB         = 
NUMST                   = 2
NCSTATES                = 5
COMPUTER                = GLNX86
BUILDARGS               =  OPTS=" -DTID01EQ=1"
MULTITASKING            = 0
INTEGER_CODE            = 0
MAT_FILE                = 0
ONESTEPFCN              = 1
TERMFCN                 = 1
B_ERTSFCN               = 0
MEXEXT                  = mexglx
EXT_MODE                = 0
TMW_EXTMODE_TESTING     = 0
EXTMODE_TRANSPORT       = 0
EXTMODE_STATIC          = 0
EXTMODE_STATIC_SIZE     = 1000000
MULTI_INSTANCE_CODE     = 0
ADD_MDL_NAME_TO_GLOBALS = 1
TGT_FCN_LIB             = GNU
MODELREFS               = 
SHARED_SRC              = 
SHARED_SRC_DIR          = 
SHARED_BIN_DIR          = 
SHARED_LIB              = 


#--------------------------- Model and reference models -----------------------
MODELLIB                  = Veicolo0lib.a
MODELREF_LINK_LIBS        = 
MODELREF_INC_PATH         = 
RELATIVE_PATH_TO_ANCHOR   = ..
# NONE: standalone, SIM: modelref sim, RTW: modelref rtw
MODELREF_TARGET_TYPE       = NONE

#-- In the case when directory name contains space ---
ifneq ($(MATLAB_ROOT),$(ALT_MATLAB_ROOT))
MATLAB_ROOT := $(ALT_MATLAB_ROOT)
endif

#----------------------------- External mode -----------------------------------
# Uncomment -DVERBOSE to have information printed to stdout
# To add a new transport layer, see the comments in
#   <matlabroot>/toolbox/simulink/simulink/extmode_transports.m
ifeq ($(EXT_MODE),1)
  EXT_CC_OPTS = -DEXT_MODE -D$(COMPUTER) #-DVERBOSE
  EXT_LIB     =
  EXT_SRC     =
  LINT_EXT_COMMON_SRC =
  LINT_EXT_TCPIP_SRC  =
  ifeq ($(EXTMODE_TRANSPORT),0) #tcpip
    EXT_SRC = ext_svr.c updown.c ext_work.c ext_svr_tcpip_transport.c
    LINT_EXT_COMMON_SRC = ext_svr.c updown.c ext_work.c
    LINT_EXT_TCPIP_SRC  = ext_svr_tcpip_transport.c
  endif
  ifeq ($(EXTMODE_TRANSPORT),1) #serial_win32
    err:
	@echo
	@echo "### ERROR: External mode serial transport only available on win32"
	@echo
  endif
  ifeq ($(TMW_EXTMODE_TESTING),1)
    EXT_SRC     += ext_test.c
    EXT_CC_OPTS += -DTMW_EXTMODE_TESTING
  endif
  ifeq ($(EXTMODE_STATIC),1)
    EXT_SRC             += mem_mgr.c
    LINT_EXT_COMMON_SRC += mem_mgr.c
    EXT_CC_OPTS         += -DEXTMODE_STATIC -DEXTMODE_STATIC_SIZE=$(EXTMODE_STATIC_SIZE)
  endif
  ifeq ($(COMPUTER),SOL2)
    EXT_LIB = -lsocket -lnsl
  endif
endif

#--------------------------- Tool Specifications -------------------------------

include $(MATLAB_ROOT)/rtw/c/tools/unixtools.mk

# Determine if we are generating an s-function
SFCN = 0
ifeq ($(MODELREF_TARGET_TYPE),SIM)
  SFCN = 1
endif
ifeq ($(B_ERTSFCN),1)
  SFCN = 1
endif

# Use GCC_TEST to do a test compile of the local source (add DO_GCC_TEST=1)
ifeq ($(DO_GCC_TEST), 1)
  GCC_TEST     = echo "Doing gcc test compile"; gcc -c -o /dev/null -Wall 
  GCC_TEST_OUT = 
else
  GCC_TEST     = echo
  GCC_TEST_OUT = > /dev/null
endif

# WARN_ON_GLNX=1 runs the linux compiler with warnings flags. On hand-written
# code we use the max amount of flags availabe while on the generated code, a
# few less.
#
# See rtw/c/tools/unixtools.mk for the definition of GCC_WARN_OPTS
#
GCC_WALL_FLAG     :=
GCC_WALL_FLAG_MAX :=
ifeq ($(COMPUTER), GLNX86)
ifeq ($(WARN_ON_GLNX), 1)
ifeq ($(SFCN),1)	
  GCC_WALL_FLAG     := COPTIMFLAGS="$(GCC_WARN_OPTS)"
  GCC_WALL_FLAG_MAX := COPTIMFLAGS="$(GCC_WARN_OPTS_MAX)"
else
  GCC_WALL_FLAG     := $(GCC_WARN_OPTS)
  GCC_WALL_FLAG_MAX := $(GCC_WARN_OPTS_MAX)
endif
endif
endif

#------------------------------ Include Path -----------------------------------

MATLAB_INCLUDES = \
	-I$(MATLAB_ROOT)/rtw/c/ert \
	-I$(MATLAB_ROOT)/extern/include \
	-I$(MATLAB_ROOT)/simulink/include \
	-I$(MATLAB_ROOT)/rtw/c/src \
	-I$(MATLAB_ROOT)/rtw/c/src/ext_mode/common

# Additional includes 
ADD_INCLUDES = \
	-I/home/lipari/Documenti/corsi/rtcs/progetto-2005 \
	-I/home/lipari/Documenti/corsi/rtcs/progetto-2005/Veicolo0_ert_rtw \
	-I$(MATLAB_ROOT)/rtw/c/libsrc \


SHARED_INCLUDES =
ifneq ($(SHARED_SRC_DIR),)
SHARED_INCLUDES = -I$(SHARED_SRC_DIR) 
endif

INCLUDES = -I. -I$(RELATIVE_PATH_TO_ANCHOR) $(MATLAB_INCLUDES) $(ADD_INCLUDES) $(USER_INCLUDES) \
	$(INSTRUMENT_INCLUDES) $(MODELREF_INC_PATH) $(SHARED_INCLUDES)


#-------------------------------- C Flags --------------------------------------

# Optimization Options
ifndef OPT_OPTS
OPT_OPTS = $(DEFAULT_OPT_OPTS)
endif

# General User Options
OPTS =

# Compiler options, etc: 
CPP_REQ_DEFINES1 = -DMODEL=$(MODEL) -DNUMST=$(NUMST) -DNCSTATES=$(NCSTATES) \
		  -DUNIX -DMAT_FILE=$(MAT_FILE) -DINTEGER_CODE=$(INTEGER_CODE) \
		  -DONESTEPFCN=$(ONESTEPFCN) -DTERMFCN=$(TERMFCN) \
		  -DHAVESTDIO -DMULTI_INSTANCE_CODE=$(MULTI_INSTANCE_CODE)\
		  -DADD_MDL_NAME_TO_GLOBALS=$(ADD_MDL_NAME_TO_GLOBALS)

CPP_REQ_DEFINES = $(CPP_REQ_DEFINES1)
ifeq ($(MODELREF_TARGET_TYPE),SIM)
CPP_REQ_DEFINES += -DMDL_REF_SIM_TGT=1
else
CPP_REQ_DEFINES += -DMT=$(MULTITASKING)
endif

ifeq ($(SFCN),0)
CC_OPTS = $(OPT_OPTS) $(OPTS) $(EXT_CC_OPTS)
CFLAGS = $(CC_OPTS) $(ANSI_OPTS) $(CPP_REQ_DEFINES) $(INCLUDES)
CPPFLAGS = $(CPP_OPTS) $(CC_OPTS) $(CPP_ANSI_OPTS) $(CPP_REQ_DEFINES) $(INCLUDES)
else
CC_OPTS = COPTIMFLAGS="$(OPT_OPTS) $(OPTS) $(ANSI_OPTS)"
CFLAGS = $(CC_OPTS) $(CPP_REQ_DEFINES) $(INCLUDES)
CC_OPTS_SFCN = COPTIMFLAGS="$(OPT_OPTS) $(ANSI_OPTS)"
CFLAGS_SFCN = $(CC_OPTS_SFCN) $(CPP_REQ_DEFINES1) $(INCLUDES)
CPPFLAGS = COPTIMFLAGS="$(OPT_OPTS) $(OPTS) $(CPP_OPTS) $(CPP_ANSI_OPTS)" $(CPP_REQ_DEFINES) $(INCLUDES)
endif

#-------------------------- Additional Libraries ------------------------------

SYSLIBS = $(EXT_LIB)
ifeq ($(SFCN),0)
SYSLIBS += -lm
endif

LIBS =

ifeq ($(OPT_OPTS),$(DEFAULT_OPT_OPTS))
ifeq ($(INTEGER_CODE),0)
ifeq ($(MODELREF_TARGET_TYPE),SIM)
LIBS += $(MATLAB_ROOT)/rtw/c/lib/glnx86/rtwlib_rtwsfcn.a
else
LIBS += $(MATLAB_ROOT)/rtw/c/lib/glnx86/rtwlib_ert.a
endif
else
LIBS += $(MATLAB_ROOT)/rtw/c/lib/glnx86/rtwlib_int_ert.a
endif
else
LIBS += rtwlib.a
endif
 
LIBS += $(S_FUNCTIONS_LIB) $(INSTRUMENT_LIBS)

ifeq ($(SFCN),1)	
LIBFIXPT = -L$(MATLAB_ROOT)/bin/$(ARCH) -lfixedpoint
else
LIBFIXPT = 
endif

#----------------------------- Source Files ------------------------------------
ADD_SRCS =
ifeq ($(MAT_FILE), 1)
ADD_SRCS += rtwlog.c
endif

ifeq ($(SFCN),0)
  SRCS  = $(MODULES) $(ADD_SRCS) $(S_FUNCTIONS)
  SRC_DEP =
  ifeq ($(MODELREF_TARGET_TYPE), NONE)
    # ERT standalone
    PRODUCT            = $(RELATIVE_PATH_TO_ANCHOR)/$(MODEL)
    BIN_SETTING        = $(LD) $(LDFLAGS) -o $(PRODUCT) $(SYSLIBS) 
    BUILD_PRODUCT_TYPE = "executable"
    SRCS               += $(MODEL).c ert_main.c $(EXT_SRC)
  else
    # Model reference rtw target
    PRODUCT            = $(MODELLIB)
    BUILD_PRODUCT_TYPE = "library"
  endif
else
  # Model Reference Simulation target, ERT S-function target
  CC                 = $(MATLAB_ROOT)/bin/mex
  ifeq ($(MODELREF_TARGET_TYPE), SIM)
  PRODUCT            = $(RELATIVE_PATH_TO_ANCHOR)/$(MODEL)_msf.$(MEXEXT)
  RTW_SFUN_SRC       = $(MODEL)_msf.c
  SRCS               = $(MODULES) $(ADD_SRCS)
  else
  PRODUCT            = $(RELATIVE_PATH_TO_ANCHOR)/$(MODEL)_sf.$(MEXEXT)
  RTW_SFUN_SRC       = $(MODEL)_sf.c
  SRCS               = $(MODULES) $(ADD_SRCS) $(S_FUNCTIONS)
  endif
  BIN_SETTING        = $(CC) -MATLAB_ARCH=$(ARCH) $(CFLAGS_SFCN) $(RTW_SFUN_SRC)  -outdir $(RELATIVE_PATH_TO_ANCHOR) -silent
  BUILD_PRODUCT_TYPE = "mex file"
  ifeq ($(B_ERTSFCN),1)
    SRCS              += $(MODEL).c
    SRC_DEP            = $(RTW_SFUN_SRC)
  endif
endif

USER_SRCS =

USER_OBJS       = $(addsuffix .o, $(basename $(USER_SRCS)))
LOCAL_USER_OBJS = $(notdir $(USER_OBJS))

OBJS      = $(addsuffix .o, $(basename $(SRCS))) $(USER_OBJS)
LINK_OBJS = $(addsuffix .o, $(basename $(SRCS))) $(LOCAL_USER_OBJS)

SHARED_SRC := $(wildcard $(SHARED_SRC))
SHARED_OBJS = $(addsuffix .o, $(basename $(SHARED_SRC)))

ifneq ($(findstring .cpp,$(suffix $(SRCS), $(USER_SRCS))),)
  LD = $(CPP)
  SYSLIBS += $(CPP_SYS_LIBS)
endif
#----------------------------- Lint (sol2 only) --------------------------------

LINT_SRCS = $(MATLAB_ROOT)/rtw/c/ert/ert_main.c \
	    $(MATLAB_ROOT)/rtw/c/src/rtwlog.c
LINT_SRCS += $(MODEL).c $(MODULES) $(USER_SRCS) $(S_FUNCTIONS)
LINTOPTSFILE = $(MODEL).lintopts

ifneq ($(LINT_EXT_COMMON_SRC), )
  LINT_SRCS += $(MATLAB_ROOT)/rtw/c/src/ext_mode/common/$(LINT_EXT_COMMON_SRC)
endif
ifneq ($(LINT_EXT_TCPIP_SRC), )
  LINT_SRCS += $(MATLAB_ROOT)/rtw/c/src/ext_mode/tcpip/$(LINT_EXT_TCPIP_SRC)
endif

LINT_ERROFF1 = E_NAME_DEF_NOT_USED2,E_NAME_DECL_NOT_USED_DEF2
LINT_ERROFF2 = $(LINT_ERROFF1),E_FUNC_ARG_UNUSED
LINT_ERROFF  = $(LINT_ERROFF2),E_INDISTING_FROM_TRUNC2,E_NAME_USED_NOT_DEF2

#--------------------------------- Rules ---------------------------------------
ifeq ($(MODELREF_TARGET_TYPE),NONE)
$(PRODUCT) : $(OBJS) $(SHARED_LIB) $(LIBS) $(SRC_DEP) $(MODELREF_LINK_LIBS)
	$(BIN_SETTING) $(LINK_OBJS) $(MODELREF_LINK_LIBS) $(SHARED_LIB) $(LIBFIXPT) $(LIBS) 
	@echo "### Created $(BUILD_PRODUCT_TYPE): $@"	
else
 ifeq ($(MODELREF_TARGET_TYPE),SIM)
  $(PRODUCT) : $(OBJS) $(SHARED_LIB) $(LIBS) $(SRC_DEP)
	@rm -f $(MODELLIB)
	ar ruvs $(MODELLIB) $(LINK_OBJS)
	@echo "### Created $(MODELLIB)"
	$(BIN_SETTING) $(MODELLIB) $(MODELREF_LINK_LIBS) $(SHARED_LIB) $(LIBFIXPT) $(LIBS) 
	@echo "### Created $(BUILD_PRODUCT_TYPE): $@"	
 else
  $(PRODUCT) : $(OBJS) $(SHARED_LIB) $(LIBS) $(SRC_DEP)
	@rm -f $(MODELLIB)
	ar ruvs $(MODELLIB) $(LINK_OBJS)
	@echo "### Created $(MODELLIB)"
	@echo "### Created $(BUILD_PRODUCT_TYPE): $@"	
 endif
endif


#--------------- Support for building referenced models -----------------------


#-------------------------- Support for building modules ----------------------

%.o : %.c
	@$(GCC_TEST) $(CPP_REQ_DEFINES) $(INCLUDES) $< $(GCC_TEST_OUT)
	$(CC) -c $(CFLAGS) $(GCC_WALL_FLAG) $<

%.o : %.cpp
	@$(GCC_TEST) $(CPP_REQ_DEFINES) $(INCLUDES) $< $(GCC_TEST_OUT)
	$(CPP) -c $(CPPFLAGS) $(GCC_WALL_FLAG) $<

%.o : $(RELATIVE_PATH_TO_ANCHOR)/%.c
	@$(GCC_TEST) $(CPP_REQ_DEFINES) $(INCLUDES) $< $(GCC_TEST_OUT)
	$(CC) -c $(CFLAGS) $(GCC_WALL_FLAG) $<

%.o : $(RELATIVE_PATH_TO_ANCHOR)/%.cpp
	@$(GCC_TEST) $(CPP_REQ_DEFINES) $(INCLUDES) $< $(GCC_TEST_OUT)
	$(CPP) -c $(CPPFLAGS) $(GCC_WALL_FLAG) $<

%.o : $(MATLAB_ROOT)/rtw/c/ert/%.c
	$(CC) -c $(CFLAGS) $(GCC_WALL_FLAG_MAX) $<

%.o : $(MATLAB_ROOT)/rtw/c/src/%.c
	$(CC) -c $(CFLAGS) $(GCC_WALL_FLAG_MAX) $<

%.o : $(MATLAB_ROOT)/rtw/c/src/ext_mode/common/%.c
	$(CC) -c $(CFLAGS) $(GCC_WALL_FLAG_MAX) $<

%.o : $(MATLAB_ROOT)/rtw/c/src/ext_mode/tcpip/%.c
	$(CC) -c $(CFLAGS) $(GCC_WALL_FLAG_MAX) $<

%.o : $(MATLAB_ROOT)/rtw/c/src/ext_mode/custom/%.c
	$(CC) -c $(CFLAGS) $(GCC_WALL_FLAG_MAX) $<

%.o : $(MATLAB_ROOT)/rtw/c/libsrc/%.c
	$(CC) -c $(CFLAGS) $(GCC_WALL_FLAG_MAX) $<



%.o : $(MATLAB_ROOT)/rtw/c/libsrc/%.cpp
	$(CPP) -c $(CPPFLAGS) $(GCC_WALL_FLAG_MAX) $<



%.o : $(MATLAB_ROOT)/simulink/src/%.cpp
	$(CPP) -c $(CPPFLAGS) $(GCC_WALL_FLAG_MAX) $<

%.o : $(MATLAB_ROOT)/simulink/src/%.c
	$(CC) -c $(CFLAGS) $(GCC_WALL_FLAG_MAX) $<

#------------------------------- Libraries -------------------------------------



MODULES_rtwlib = \
    rt_atan2.o \
    rt_atan232.o \
    rt_backsubcc_dbl.o \
    rt_backsubcc_sgl.o \
    rt_backsubrc_dbl.o \
    rt_backsubrc_sgl.o \
    rt_backsubrr_dbl.o \
    rt_backsubrr_sgl.o \
    rt_enab.o \
    rt_forwardsubcc_dbl.o \
    rt_forwardsubcc_sgl.o \
    rt_forwardsubcr_dbl.o \
    rt_forwardsubcr_sgl.o \
    rt_forwardsubrc_dbl.o \
    rt_forwardsubrc_sgl.o \
    rt_forwardsubrr_dbl.o \
    rt_forwardsubrr_sgl.o \
    rt_hypot.o \
    rt_hypot32.o \
    rt_i32zcfcn.o \
    rt_intrp1flatcd.o \
    rt_intrp1flatcf.o \
    rt_intrp1flatd.o \
    rt_intrp1flatf.o \
    rt_intrp1lincd.o \
    rt_intrp1lincf.o \
    rt_intrp1linxd.o \
    rt_intrp1linxf.o \
    rt_intrp2flatcd.o \
    rt_intrp2flatcf.o \
    rt_intrp2flatd.o \
    rt_intrp2flatf.o \
    rt_intrp2lincd.o \
    rt_intrp2lincf.o \
    rt_intrp2lind.o \
    rt_intrp2linf.o \
    rt_intrp2linxd.o \
    rt_intrp2linxf.o \
    rt_intrp3lind.o \
    rt_intrp3linf.o \
    rt_intrp4lind.o \
    rt_intrp4linf.o \
    rt_intrp5lind.o \
    rt_intrp5linf.o \
    rt_intrpnflatcd.o \
    rt_intrpnflatcf.o \
    rt_intrpnflatd.o \
    rt_intrpnflatf.o \
    rt_intrpnlincd.o \
    rt_intrpnlincf.o \
    rt_intrpnlind.o \
    rt_intrpnlinf.o \
    rt_intrpnlinxd.o \
    rt_intrpnlinxf.o \
    rt_intrpnspld.o \
    rt_intrpnsplf.o \
    rt_logging.o \
    rt_look.o \
    rt_look1d.o \
    rt_look1d32.o \
    rt_look2d32_general.o \
    rt_look2d32_normal.o \
    rt_look2d_general.o \
    rt_look2d_normal.o \
    rt_look32.o \
    rt_lookflat1bincsd.o \
    rt_lookflat1bincsf.o \
    rt_lookflat1binczd.o \
    rt_lookflat1binczf.o \
    rt_lookflat1evncsd.o \
    rt_lookflat1evncsf.o \
    rt_lookflat1evnczd.o \
    rt_lookflat1evnczf.o \
    rt_lookflat1lincsd.o \
    rt_lookflat1lincsf.o \
    rt_lookflat1linczd.o \
    rt_lookflat1linczf.o \
    rt_lookflat2bincsd.o \
    rt_lookflat2bincsf.o \
    rt_lookflat2binczd.o \
    rt_lookflat2binczf.o \
    rt_lookflat2evncsd.o \
    rt_lookflat2evncsf.o \
    rt_lookflat2evnczd.o \
    rt_lookflat2evnczf.o \
    rt_lookflat2lincsd.o \
    rt_lookflat2lincsf.o \
    rt_lookflat2linczd.o \
    rt_lookflat2linczf.o \
    rt_lookflatnbincsd.o \
    rt_lookflatnbincsf.o \
    rt_lookflatnbinczd.o \
    rt_lookflatnbinczf.o \
    rt_lookflatnevncsd.o \
    rt_lookflatnevncsf.o \
    rt_lookflatnevnczd.o \
    rt_lookflatnevnczf.o \
    rt_lookflatnlincsd.o \
    rt_lookflatnlincsf.o \
    rt_lookflatnlinczd.o \
    rt_lookflatnlinczf.o \
    rt_looklin1bincsd.o \
    rt_looklin1bincsf.o \
    rt_looklin1binczd.o \
    rt_looklin1binczf.o \
    rt_looklin1binxsd.o \
    rt_looklin1binxsf.o \
    rt_looklin1binxzd.o \
    rt_looklin1binxzf.o \
    rt_looklin1evncsd.o \
    rt_looklin1evncsf.o \
    rt_looklin1evnczd.o \
    rt_looklin1evnczf.o \
    rt_looklin1evnxsd.o \
    rt_looklin1evnxsf.o \
    rt_looklin1evnxzd.o \
    rt_looklin1evnxzf.o \
    rt_looklin1lincsd.o \
    rt_looklin1lincsf.o \
    rt_looklin1linczd.o \
    rt_looklin1linczf.o \
    rt_looklin1linxsd.o \
    rt_looklin1linxsf.o \
    rt_looklin1linxzd.o \
    rt_looklin1linxzf.o \
    rt_looklin2bincsd.o \
    rt_looklin2bincsf.o \
    rt_looklin2binczd.o \
    rt_looklin2binczf.o \
    rt_looklin2binxsd.o \
    rt_looklin2binxsf.o \
    rt_looklin2binxzd.o \
    rt_looklin2binxzf.o \
    rt_looklin2evncsd.o \
    rt_looklin2evncsf.o \
    rt_looklin2evnczd.o \
    rt_looklin2evnczf.o \
    rt_looklin2evnxsd.o \
    rt_looklin2evnxsf.o \
    rt_looklin2evnxzd.o \
    rt_looklin2evnxzf.o \
    rt_looklin2lincsd.o \
    rt_looklin2lincsf.o \
    rt_looklin2linczd.o \
    rt_looklin2linczf.o \
    rt_looklin2linxsd.o \
    rt_looklin2linxsf.o \
    rt_looklin2linxzd.o \
    rt_looklin2linxzf.o \
    rt_looklinnbincsd.o \
    rt_looklinnbincsf.o \
    rt_looklinnbinczd.o \
    rt_looklinnbinczf.o \
    rt_looklinnbinxsd.o \
    rt_looklinnbinxsf.o \
    rt_looklinnbinxzd.o \
    rt_looklinnbinxzf.o \
    rt_looklinnevncsd.o \
    rt_looklinnevncsf.o \
    rt_looklinnevnczd.o \
    rt_looklinnevnczf.o \
    rt_looklinnevnxsd.o \
    rt_looklinnevnxsf.o \
    rt_looklinnevnxzd.o \
    rt_looklinnevnxzf.o \
    rt_looklinnlincsd.o \
    rt_looklinnlincsf.o \
    rt_looklinnlinczd.o \
    rt_looklinnlinczf.o \
    rt_looklinnlinxsd.o \
    rt_looklinnlinxsf.o \
    rt_looklinnlinxzd.o \
    rt_looklinnlinxzf.o \
    rt_looksplnbincsd.o \
    rt_looksplnbincsf.o \
    rt_looksplnbinczd.o \
    rt_looksplnbinczf.o \
    rt_looksplnbinssd.o \
    rt_looksplnbinssf.o \
    rt_looksplnbinszd.o \
    rt_looksplnbinszf.o \
    rt_looksplnbinxsd.o \
    rt_looksplnbinxsf.o \
    rt_looksplnbinxzd.o \
    rt_looksplnbinxzf.o \
    rt_looksplnevncsd.o \
    rt_looksplnevncsf.o \
    rt_looksplnevnczd.o \
    rt_looksplnevnczf.o \
    rt_looksplnevnssd.o \
    rt_looksplnevnssf.o \
    rt_looksplnevnszd.o \
    rt_looksplnevnszf.o \
    rt_looksplnevnxsd.o \
    rt_looksplnevnxsf.o \
    rt_looksplnevnxzd.o \
    rt_looksplnevnxzf.o \
    rt_looksplnlincsd.o \
    rt_looksplnlincsf.o \
    rt_looksplnlinczd.o \
    rt_looksplnlinczf.o \
    rt_looksplnlinssd.o \
    rt_looksplnlinssf.o \
    rt_looksplnlinszd.o \
    rt_looksplnlinszf.o \
    rt_looksplnlinxsd.o \
    rt_looksplnlinxsf.o \
    rt_looksplnlinxzd.o \
    rt_looksplnlinxzf.o \
    rt_lu_cplx.o \
    rt_lu_cplx_sgl.o \
    rt_lu_real.o \
    rt_lu_real_sgl.o \
    rt_matdivcc_dbl.o \
    rt_matdivcc_sgl.o \
    rt_matdivcr_dbl.o \
    rt_matdivcr_sgl.o \
    rt_matdivrc_dbl.o \
    rt_matdivrc_sgl.o \
    rt_matdivrr_dbl.o \
    rt_matdivrr_sgl.o \
    rt_matmultandinccc_dbl.o \
    rt_matmultandinccc_sgl.o \
    rt_matmultandinccr_dbl.o \
    rt_matmultandinccr_sgl.o \
    rt_matmultandincrc_dbl.o \
    rt_matmultandincrc_sgl.o \
    rt_matmultandincrr_dbl.o \
    rt_matmultandincrr_sgl.o \
    rt_matmultcc_dbl.o \
    rt_matmultcc_sgl.o \
    rt_matmultcr_dbl.o \
    rt_matmultcr_sgl.o \
    rt_matmultrc_dbl.o \
    rt_matmultrc_sgl.o \
    rt_matmultrr_dbl.o \
    rt_matmultrr_sgl.o \
    rt_matrx.o \
    rt_nrand.o \
    rt_plookbincd.o \
    rt_plookbincf.o \
    rt_plookbinkcd.o \
    rt_plookbinkcf.o \
    rt_plookbinxd.o \
    rt_plookbinxf.o \
    rt_plookevncd.o \
    rt_plookevncf.o \
    rt_plookevnkcd.o \
    rt_plookevnkcf.o \
    rt_plookevnxd.o \
    rt_plookevnxf.o \
    rt_plooklincd.o \
    rt_plooklincf.o \
    rt_plooklinkcd.o \
    rt_plooklinkcf.o \
    rt_plooklinxd.o \
    rt_plooklinxf.o \
    rt_printf.o \
    rt_sat_div_int16.o \
    rt_sat_div_int32.o \
    rt_sat_div_int8.o \
    rt_sat_div_uint16.o \
    rt_sat_div_uint32.o \
    rt_sat_div_uint8.o \
    rt_sat_prod_int16.o \
    rt_sat_prod_int32.o \
    rt_sat_prod_int8.o \
    rt_sat_prod_uint16.o \
    rt_sat_prod_uint32.o \
    rt_sat_prod_uint8.o \
    rt_tdelay.o \
    rt_urand.o \
    rt_zcfcn.o \


rtwlib.a : $(MAKEFILE) rtw_proj.tmw $(MODULES_rtwlib)
	@echo "### Creating $@ "
	ar rs $@ $(MODULES_rtwlib)
	@echo "### $@ Created "



#----------------------------- Dependencies ------------------------------------

$(OBJS) : $(MAKEFILE) rtw_proj.tmw

$(SHARED_LIB) : $(SHARED_SRC)
	@echo "### Creating $@ "
	cd $(SHARED_BIN_DIR); $(CC) -c $(CFLAGS) $(GCC_WALL_FLAG_MAX) $(notdir $?)
	ar ruvs $@ $(SHARED_OBJS)
	@echo "### $@ Created "


#--------- Miscellaneous rules to purge, clean and lint (sol2 only) ------------

purge : clean
	@echo "### Deleting the generated source code for $(MODEL)"
	@\rm -f $(MODEL).c $(MODEL).h $(MODEL)_types.h $(MODEL)_data.c \
	        $(MODEL)_private.h $(MODEL).rtw $(MODULES) rtw_proj.tmw $(MAKEFILE)

clean :
	@echo "### Deleting the objects, $(PRODUCT)"
	@\rm -f $(LINK_OBJS) $(PRODUCT) 

lint  : rtwlib.ln
	@lint -errchk -errhdr=%user -errtags=yes -F -L. -lrtwlib -x -Xc \
	      -erroff=$(LINT_ERROFF) \
	      -D_POSIX_C_SOURCE $(CFLAGS) $(LINT_SRCS)
	@\rm -f $(LINTOPTSFILE)
	@echo
	@echo "### Created lint output only, no executable"
	@echo

rtwlib.ln : $(MAKEFILE) rtw_proj.tmw
	@echo
	@echo "### Linting ..."
	@echo
	@\rm -f llib-lrtwlib.ln $(LINTOPTSFILE)
	@echo "-dirout=. -errchk -errhdr=%user " >> $(LINTOPTSFILE)
	@echo "-errtags -F -ortwlib -x -Xc " >> $(LINTOPTSFILE)
	@echo "-erroff=$(LINT_ERROFF) " >> $(LINTOPTSFILE)
	@echo "-D_POSIX_C_SOURCE $(CFLAGS) " >> $(LINTOPTSFILE)
	@for file in $(MATLAB_ROOT)/rtw/c/libsrc/*.c; do \
	  echo "$$file " >> $(LINTOPTSFILE); \
	done
	lint -flagsrc=$(LINTOPTSFILE)


# EOF: ert_unix.tmf
