/*
 * Project: S.Ha.R.K.
 *
 * Coordinators: 
 *   Giorgio Buttazzo    <giorgio@sssup.it>
 *   Paolo Gai           <pj@gandalf.sssup.it>
 *
 * Authors     : 
 *   Paolo Gai           <pj@gandalf.sssup.it>
 *   (see the web pages for full authors list)
 *
 * ReTiS Lab (Scuola Superiore S.Anna - Pisa - Italy)
 *
 * http://www.sssup.it
 * http://retis.sssup.it
 * http://shark.sssup.it
 */

/*
 ------------
 CVS :        $Id: initfile.c,v 1.1 2004/03/13 14:50:57 giacomo Exp $

 File:        $File$
 Revision:    $Revision: 1.1 $
 Last update: $Date: 2004/03/13 14:50:57 $
 ------------

 System initialization file

 This file contains the 2 functions needed to initialize the system.

 These functions register the following levels:

 an EDF (Earliest Deadline First) level
 a RR (Round Robin) level
 a CBS (Costant Bandwidth Server) level
 a Dummy level

 It can accept these task models:

 HARD_TASK_MODEL (wcet+mit) at level 0
 SOFT_TASK_MODEL (met, period) at level 1
 NRT_TASK_MODEL  at level 2

 This file is similar to the configuration of kernel/init/hartik3.c

 TICK is set to 0 (one-shot timer is used)
*/

/*
 * Copyright (C) 2000 Paolo Gai
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "kernel/kern.h"
#include "edf/edf/edf.h"
#include "cbs/cbs/cbs.h"
#include "rr/rr/rr.h"
#include "rrsoft/rrsoft/rrsoft.h"
#include "dummy/dummy/dummy.h"

#include "sem/sem/sem.h"
#include "hartport/hartport/hartport.h"
#include "cabs/cabs/cabs.h"
#include "intdrive/intdrive/intdrive.h"
#include <drivers/shark_linuxc26.h>
#include <drivers/shark_input26.h>
#include <drivers/shark_keyb26.h>
#include <drivers/shark_pci26.h>


#define INTDRIVE_Q 1000
#define INTDRIVE_U 1000
#define INTDRIVE_FLAG 0

/*+ sysyem tick in us +*/
#define TICK 0

/*+ RR tick in us +*/
#define RRTICK 10000

int device_drivers_init() {
  KEYB_PARMS  kparms = BASE_KEYB;
  int err=0;
  
  LINUXC26_register_module(TRUE);
  PCI26_init();
  INPUT26_init();

  /*keyb_def_map(kparms, KEYMAP_IT);*/
  //keyb_def_ctrlC(kparms, NULL);
  err=KEYB26_init(&kparms);
  if (err) exit(err);


  return 0;
}

TIME __kernel_register_levels__(void *arg)
{
  struct multiboot_info *mb = (struct multiboot_info *)arg;

  INTDRIVE_register_level(INTDRIVE_Q, INTDRIVE_Q, INTDRIVE_U, INTDRIVE_FLAG);
  EDF_register_level(EDF_ENABLE_ALL);
  CBS_register_level(CBS_ENABLE_ALL, 1);
  RR_register_level(RRTICK, RR_MAIN_YES, mb);
  dummy_register_level();
  SEM_register_module();
  CABS_register_module();

  return TICK;
}

TASK __init__(void *arg)
{
  struct multiboot_info *mb = (struct multiboot_info *)arg;

/*   KEYB_PARMS kparms = BASE_KEYB; */

  HARTPORT_init();
  device_drivers_init();

  __call_main__(mb);

  return (void *)0;
}

