#include "kernel/kern.h"
#include "cabs/cabs/cabs.h"

#include "plant_model.h"
#include "sensors.h"
#include <drivers/shark_keyb26.h>
#include "Veicolo0_ert_rtw/Veicolo0.h"

int sensors[3];

PID  spid, simpid, cpid;

#define YOFF    10

#define LOG_SIZE      10000

struct _log_struct {
  TIME    t ;
  real_T  omega_w;
  real_T  omega_e;
  real_T  v;
} log_array[LOG_SIZE];


TASK LOG_body(void *arg)
{
  TIME sum, max, curr;
  int n;
  int i = 0;
  int log_index = 0;
  time_t  mytime;

  printf_xy(0, 0 + YOFF, WHITE, "time    : ");
  printf_xy(0, 1 + YOFF, WHITE, "Omega_w : ");
  printf_xy(0, 2 + YOFF, WHITE, "Omega_e : ");
  printf_xy(0, 3 + YOFF, WHITE, "v_v     : ");

  printf_xy(0, 5 + YOFF, WHITE, "Sim task");
  printf_xy(0, 6 + YOFF, WHITE, "max exec :");
  printf_xy(0, 7 + YOFF, WHITE, "avg exec :");


  printf_xy(30, 5 + YOFF, WHITE, "sensor task");
  printf_xy(30, 6 + YOFF, WHITE, "max exec :");
  printf_xy(30, 7 + YOFF, WHITE, "avg exec :");

  printf_xy(60, 5 + YOFF, WHITE, "control task");
  printf_xy(60, 6 + YOFF, WHITE, "max exec :");
  printf_xy(60, 7 + YOFF, WHITE, "avg exec :");


  while(1) {
    i++;
    printf_xy(10, 0 + YOFF, WHITE + (i%2), "%g", rtsiGetT(&Veicolo0_M->solverInfo));
    printf_xy(10, 1 + YOFF, WHITE + (i%2), "%g", read_sensor(0));
    printf_xy(10, 2 + YOFF, WHITE + (i%2), "%g", read_sensor(1));
    printf_xy(10, 3 + YOFF, WHITE + (i%2), "%g", read_sensor(2));
      
    if (log_index < LOG_SIZE) {
      log_array[log_index].t       = sys_gettime(&mytime);
      log_array[log_index].omega_w = read_sensor(0);
      log_array[log_index].omega_e = read_sensor(1);
      log_array[log_index].v       = read_sensor(2);
      log_index ++;
    }

    jet_getstat(simpid, &sum, &max, &n, &curr);

    printf_xy(15, 6 + YOFF, WHITE + (i%2), "%d", max);
    if (n > 0) printf_xy(15, 7 + YOFF, WHITE + (i%2), "%d", sum/n);

    jet_getstat(spid, &sum, &max, &n, &curr);

    printf_xy(45, 6 + YOFF, WHITE + (i%2), "%d", max);
    if (n > 0) printf_xy(45, 7 + YOFF, WHITE + (i%2), "%d", sum/n);

    jet_getstat(cpid, &sum, &max, &n, &curr);

    printf_xy(75, 6 + YOFF, WHITE + (i%2), "%d", max);
    if (n > 0) printf_xy(75, 7 + YOFF, WHITE + (i%2), "%d", sum/n);

    task_endcycle();
  }
}


PID activate_log(int period, int wcet)
{
  HARD_TASK_MODEL     LOG_task;
  PID                 LOG_pid;

  hard_task_default_model(LOG_task);
  hard_task_def_mit(LOG_task, period);
  hard_task_def_usemath(LOG_task);
  hard_task_def_wcet(LOG_task, wcet);
  hard_task_def_periodic(LOG_task);
  hard_task_def_ctrl_jet(LOG_task);

  LOG_pid = task_create("LOG", LOG_body, &LOG_task,NULL);
  if (LOG_pid == NIL) {
    cprintf("Error: Cannot create RealTime Workshop [LOG] Task\n");
    exit(-1);
  }

   task_activate(LOG_pid);

   return LOG_pid;
 }

 TASK CONTROL_body(void *arg)
 {
   int i = 0;
   while(1) {
     actuate( 0.9, 0);   // mu
     actuate(10.0, 1); // accelleratore
     actuate( 1.0, 2);     // prima marcia
     i++;
     printf_xy(50,5, WHITE + (i%2), "Control");     
     task_endcycle();
   }
 }


 PID activate_control(int period, int wcet)
 {
   HARD_TASK_MODEL     CONTROL_task;
   PID                 CONTROL_pid;

   hard_task_default_model(CONTROL_task);
   hard_task_def_mit(CONTROL_task, period);
   hard_task_def_wcet(CONTROL_task, wcet);
   hard_task_def_usemath(CONTROL_task);
   hard_task_def_ctrl_jet(CONTROL_task);

   CONTROL_pid = task_create("CONTROL", CONTROL_body, &CONTROL_task,NULL);
   if (CONTROL_pid == NIL) {
     cprintf("Error: Cannot create RealTime Workshop [CONTROL] Task\n");
     exit(-1);
   }

   task_activate(CONTROL_pid);

   return CONTROL_pid;
 }


void ending_system(KEY_EVT *e) 
{
    exit(0);
}


int main() {

  int i;
  KEY_EVT ev;
   
  clear();

  ev.ascii = 'c';
  ev.scan  = KEY_C;
  ev.status = KEY_PRESSED;
  ev.flag = CNTR_BIT;
  keyb_hook(ev, ending_system, FALSE);

  printf_xy(0,0,WHITE,"Initialize RTW (Press ctrl-c to exit)"); 

  Init_Rtw();

  simpid = simulationStart();

  for (i=0; i<3; i++) sensors[i] = i; 

  spid = init_sensor_board(sensors, 3, 2000, 300, "mysensors");

  cpid = activate_control(10000, 100); 
  activate_log(50000, 100); 

  printf_xy(0,2,WHITE,"Done; waiting for end..."); 

  while(simulationIsRunning());
 
  Close_RealTime_Workshop();

  return 0;

}


void * mymemset(void *p, char c, size_t count)
{
  return memset(p, c, count);
}
