/*
 * @(#)mcl.h    generated by: makeheader 4.21  Mon Aug 16 03:50:16 2004
 *
 *		built from:	../../src/include/pragma_interface.h
 *				include/speccmn.h
 *				include/pkg.h
 *				modver/modver.cpp
 *				speculate/BuildOutOfLine.cpp
 *				speculate/Speculate.cpp
 *				speculate/c3.cpp
 *				speculate/cmatrix.cpp
 *				speculate/cstring.cpp
 */

#ifndef mcl_h
#define mcl_h


/* Copyright 2003 The MathWorks, Inc. */

/*
 * Prevent g++ from making copies of vtable and typeinfo data
 * in every compilation unit.  By allowing for only one, we can
 * save space and prevent some situations where the linker fails
 * to coalesce them properly into a single entry.
 *
 * References:
 *    http://gcc.gnu.org/onlinedocs/gcc/Vague-Linkage.html#Vague%20Linkage
 *    http://gcc.gnu.org/onlinedocs/gcc/C---Interface.html
 */

#ifdef __cplusplus
#  ifdef GLNX86
#    pragma interface
#  endif
#endif



/* $Revision: 1.4 $ */
#if !defined(SPECCMN_H)
#define SPECCMN_H

#undef mxGetPi
#undef mxGetPr

/**
 * //////////////////////////////////////////
 * Compile C functions inline or out of line
 */

#ifdef __cplusplus
/* Use the Speculate namespace */
namespace Speculate{}
using namespace Speculate;
/*using namespace std;*/
#endif

/* Use this if the mbuild option -inline is not specified */
#ifndef ARRAY_ACCESS_INLINING
#define ARRAY_ACCESS_INLINING
#endif

/*#define MW_INLINE*/

#ifdef MW_INLINE
#   ifdef WIN32
#       define CINLINE __inline
#   else
#       ifdef __cplusplus
#           undef CINLINE
#           define CINLINE inline
#       else    
#           define CINLINE
#       endif
#   endif
#else
#   define CINLINE
#endif

#ifdef MW_OUTOFLINE
#   undef CINLINE
#   define CINLINE
#endif

#ifdef WIN32
#   pragma warning( disable : 4512)
#endif

/**
 * //////////////////////////////////////////
 * Compile with which version of matlab headers
 */
#if defined(__cplusplus) && !defined(MW_OUTOFLINE)
#define NO_CPPMATH_INITIALIZATION 1
#include "version.h"  // Global #defines and platform dependent settings
#include "dblmtrx.h"  // MATLAB C++ Math Library
#else
#   include "libmatlb.h"
#endif

/**
 * //////////////////////////////////////////
 * extern defs of un-PUBLISHed util fns
 */
extern int utDbl2Int(double x);
extern bool utDblIsInt(double x);
extern void *utMallocWithCheck(size_t size);
extern void utFree(void *ptr);
/**
 * end of util defs
 */

#endif /*SPECCMN_H*/





#ifndef IMPORT
#define IMPORT extern
#define IMPORT_VAR extern
#endif


#ifdef __cplusplus
extern "C" {
#endif

IMPORT_VAR char *libmwmcl_version;

IMPORT_VAR char *libmwmcl_build_date;


#ifdef __cplusplus
}
#endif



/**
 * Speculate.h: interface for the Speculate class.
 *
 * ////////////////////////////////////////////////////////////////////
 */

#if !defined(SPECULATE_H)
#define SPECULATE_H

#define mclInitializeNaNUntouched(x) UT_SET_NAN_VALUE(*x,UT_NAN_NEVER_TOUCHED)
#if defined(__cplusplus) && !defined(MW_OUTOFLINE)

namespace Speculate  
{
    /* Conversion Functions */
    inline double ArrayToDs(const mwArray &a)
    {
	return *mxGetPr(a.GetData());
    }

    /* Marshal in */
    inline bool CanMarshalInDs(mwArray *a)
    {
	/* test for compatibility */
        if(!a->IsUndefined() 
           && mxIsScalarDoubleFlagSet(a->GetData())
           && mxGetPi(a->GetData()) == NULL)
	{
	    return true;
	}
	else
	    return false;
    }

    inline bool CanMarshalInCmatrix(mwArray *a)
    {
	/* test for compatibility */
	if(!a->IsUndefined() && 
           mxGetClassID(a->GetData()) == mxDOUBLE_CLASS && 
           mxGetPi(a->GetData()) == NULL &&
           mxGetNumberOfDimensions(a->GetData()) <= 2)
	{
	    return true;
	}
	else
	    return false;
    }

    inline bool CanMarshalInC3(mwArray *a)
    {
        /* test for compatibility */
	if(!a->IsUndefined() &&
           mxGetClassID(a->GetData()) == mxDOUBLE_CLASS && 
           mxGetPi(a->GetData()) == NULL &&
           mxGetNumberOfDimensions(a->GetData()) <= 3)
	{
	    return true;
	}
	else
	    return false;
    }

    inline bool CanMarshalInCstring(mwArray *a)
    {
	/* test for compatibility */
	if(!a->IsUndefined() &&
           mxIsChar(a->GetData()) &&
           mxGetM(a->GetData()) == 1 &&
           mxGetNumberOfDimensions(a->GetData()) == 2)
	{
	    return true;
	}
	else
	    return false;
    }

    inline void MarshalInDs(double *ds, mwArray *a)
    {
        a->Unshare();
        *ds = ArrayToDs(*a);
    }

    /* Marshal out */

    inline void MarshalOutDs(double *ds, mwArray *a)
    {
        if(!(UT_IS_NAN_VALUE(*ds, UT_NAN_NEVER_TOUCHED)))
        {
            if(UT_IS_NAN_VALUE(*ds, UT_NAN_FORLOOP_EMPTY))
            {
                *a = mwArray();
            }
            else
            {
                *a = mwArray( *ds );
            }
            mclInitializeNaNUntouched(ds);
        }
    }
}
#endif /* __cplusplus */
#ifdef __cplusplus
    extern "C" {
#endif

#if defined(MW_INLINE)

    /**
     * /////////////////////////////////////////////////
     * /// Ds functions
     * /////////////////////////////////////////////////
     */
    CINLINE double mclArrayToDs(mxArray *a)
    {        
        double dret = *mxGetPr(a);
        if (mxGetRefCount(a) == 0) {  
            mclDestroyArray(a);
        }
	return dret;
    }

    CINLINE bool mclCanMarshalInDs(mxArray **a)
    {
	/* test for compatibility */
        if(*a != NULL && mxIsScalarDoubleFlagSet(*a) && mxGetPi(*a) == NULL)
        {
	    return true;
        }
	else
        {
	    return false;
        }
    }

    CINLINE bool mclCanMarshalInCmatrix(mxArray **a)
    {
        /* test for compatibility */
        if(*a != NULL &&
           mxGetClassID(*a) == mxDOUBLE_CLASS && 
           mxGetPi(*a) == NULL &&
           mxGetNumberOfDimensions(*a) <= 2)
        {
            return true;
        }
        else
            return false;
    }

    CINLINE bool mclCanMarshalInC3(mxArray **a)
    {
        /* test for compatibility */
        if(*a != NULL &&
           mxGetClassID(*a) == mxDOUBLE_CLASS && 
           mxGetPi(*a) == NULL &&
           mxGetNumberOfDimensions(*a) <= 3)
        {
            return true;
        }
        else
            return false;
    }

    CINLINE bool mclCanMarshalInCstring(mxArray **a)
    {
        /* test for compatibility */
        if(*a != NULL &&
           mxIsChar(*a) &&
           mxGetM(*a) == 1 &&
           mxGetNumberOfDimensions(*a) == 2)
        {
            return true;
        }
        else
            return false;
    }

    CINLINE void mclMarshalInDs(double *d, mxArray **a)
    {
        mxUnshare(*a);
        *d = *mxGetPr(*a);
    }

    CINLINE void mclMarshalOutDs(double *d, mxArray **a)
    {
        if(!(UT_IS_NAN_VALUE(*d, UT_NAN_NEVER_TOUCHED)))
        {
            if(UT_IS_NAN_VALUE(*d, UT_NAN_FORLOOP_EMPTY))
            {
                mlfAssign(a, mclCreateEmptyArray());
            }
            else
            {
                mlfAssign(a, mlfScalar(*d));
            }
            mclInitializeNaNUntouched(d);
        }
    }

    /**
     * /////////////////////////////////////////////////
     * /// Other functions
     * /////////////////////////////////////////////////
     */
       
    /* 
     *  If the result of an operation is a different array
     *  and the ref count is greater than 1 make the ref count 1 for sanity
     */
    CINLINE void mclAdjustRefCount(mxArray *pshadow, mxArray *pmxarray)
    {
        if((pmxarray != pshadow) && (mxGetRefCount(pmxarray) > 0)) 
        {
            mxDecrementRefCount(pmxarray);
        }
    }

    CINLINE int mclCountRange(double start, double inc, double end)
    {
        double count;

        count = mxColonop_size(start, inc, end);
        return utDbl2Int(count);
    }

    /* This calculation takes 1-based indices and returns a single 0-based index */
    /* Check for integral value should have been performed by caller*/
    CINLINE int mxGetSingleIndex(int actualnsubs, const unsigned int *actualsubs, 
                                 int nsubs, unsigned int *subs)
    {
        int idx, i;

        utAssert(nsubs >= 0);
        utAssert(nsubs > 0 && subs != NULL);

        /* All sanity checks follow */

        /* Change from 1-based to 0-based */
        for(i=0;i<nsubs;i++)
        {
            subs[i] = subs[i] - 1;
        }

        /* Check for inbounds */
        if(nsubs > actualnsubs)
        {
            return -1;
        }

        /* Check that each sub is in range */
        for(i=0;i<nsubs;i++)
        {
            if(subs[i] >= actualsubs[i])
            {
                return -1;
            }
        }

        /* Get the single index */
        idx = 0;
        if(nsubs <= actualnsubs)
	{
            i = nsubs;
            actualnsubs = 1;
            while (i--)
            {
                idx += *subs++ * actualnsubs;
                actualnsubs *= *actualsubs++;
            }
	}
	
        return idx;
    }

#else
    /**
     * /////////////////////////////////////////////////
     * /// DS functions
     * /////////////////////////////////////////////////
     */
    IMPORT double mclArrayToDs(mxArray *a);


    IMPORT bool mclCanMarshalInDs(mxArray **a);

    IMPORT bool mclCanMarshalInCmatrix(mxArray **a);

    IMPORT bool mclCanMarshalInC3(mxArray **a);

    IMPORT bool mclCanMarshalInCstring(mxArray **a);

    IMPORT void mclMarshalInDs(double *d, mxArray **a);

    IMPORT void mclMarshalOutDs(double *d, mxArray **a);


    /**
     * /////////////////////////////////////////////////
     * /// Other functions
     * /////////////////////////////////////////////////
     */
    IMPORT void mclAdjustRefCount(mxArray *pshadow, mxArray *pmxarray);

    IMPORT int mxGetSingleIndex(int actualnsubs, const unsigned int *actualsubs, 
                                int nsubs, const unsigned int *subs);

    IMPORT int mclCountRange(double start, double inc, double end);


#endif /* MW_INLINE */

#ifdef __cplusplus
    }
#endif /* extern "C" */

#endif /* !defined(SPECULATE_H) */



/**
 * C3.h: interface for the C3 class.
 *
 * ////////////////////////////////////////////////////////////////////
 */

#if !defined(MW_C3_H)
#define MW_C3_H

#include <memory.h>

#if defined(__cplusplus) && !defined(MW_OUTOFLINE)
class mwArray;
#endif

typedef struct C3  
{
    mxArray      *m_pshadow;
    double	 *m_pr;
    unsigned int  m_dims[3];
    bool          m_init;

#if defined(__cplusplus) && !defined(MW_OUTOFLINE)
    mwArray        *m_cppshadow;    

public:
    C3(): m_pr(0), m_init(false), m_cppshadow(0)
    {
	memset(&m_dims, 0, 3*sizeof(unsigned int));
    }

    ~C3()	    /* Not virtual on purpose. Do not change */
    {
	Cleanup();
    }

    void Cleanup()
    {
        if(m_cppshadow)
	{
            m_cppshadow->~mwArray();
            m_cppshadow->freeMem();
            m_pr = 0;
	}

        if(m_pr)
        {
            delete [] m_pr;
	    m_pr = 0;
        }

        memset(&m_dims, 0, 3*sizeof(unsigned int));
        m_cppshadow = 0;
        m_init = false;
    }

    /* Conversion ctor */
    C3(mwArray &a)
    {
        SetArray(a);
    }

    /* Conversion operators */
    C3 &operator= (const mwArray &other)
    {
        MarshalIn(const_cast<mwArray*>(&other));
        return *this;
    }

    void SetArray(const mwArray &a)
    {
        /* cleanup existing contents */
        Cleanup();

        /* set shadow using placement new */
	m_cppshadow = new(1) mwArray(a);

        /* set important values */

        /* get dims. if not 3 fill with 0's */
        if(mxGetNumberOfDimensions(m_cppshadow->GetData()) == 3)
        {
            memcpy(&m_dims, mxGetDimensions(m_cppshadow->GetData()), 3*sizeof(unsigned int));
        }
        else if(mxGetNumberOfDimensions(m_cppshadow->GetData()) == 2)
        {
            m_dims[0] = mxGetM(m_cppshadow->GetData());
            m_dims[1] = mxGetN(m_cppshadow->GetData());
            m_dims[2] = 1;
        }
        else
        {
            utAssert(mxGetNumberOfDimensions(m_cppshadow->GetData()) == 1);
            m_dims[0] = mxGetM(m_cppshadow->GetData());
            m_dims[1] = 1;
            m_dims[2] = 1;

        }

	m_pr = mxGetPr(m_cppshadow->GetData());

         /* set shadow */
	m_init = true;
    }

    operator mwArray()
    {
        if(m_init && m_cppshadow)
        {
            return mwArray(*m_cppshadow);
        }
        else if(m_init)
        {
            mxArray *a = mxCreateDoubleMatrix(0,0,mxREAL);
            mxSetDimensions(a, (const int *)&(m_dims), 3);
            mxSetPr(a,m_pr);
            mxSetPi(a,NULL);

            return mwArray(a);
        }
        else
        {
            /* ERROR: Throw Exception */
            return mwArray();
        }
    }

    void IndexAssign(double i, double r)
    {
        int idx;
        unsigned int dims[1] = {utDbl2Int(i)};
        
        idx = mxGetSingleIndex(3, m_dims, 1, dims);
        
        if(idx != -1)
        {
            m_pr[idx] = r;
        }
        else
        {
            mwArray tmpI(i), tmpR(r);
            IndexAssign(tmpI, tmpR);
        }
    }

    void IndexAssign(double i, double j, double r)
    { 
        int idx;
        unsigned int dims[2] = {utDbl2Int(i),utDbl2Int(j)};

        idx = mxGetSingleIndex(3, m_dims, 2, dims);
        
        if(idx != -1)
        {
            m_pr[idx] = r;
        }
        else
        {
            mwArray tmpI(i), tmpJ(j), tmpR(r);
            IndexAssign(tmpI, tmpJ, tmpR);
        }
    }

    void IndexAssign(double i, double j, double k, double r)
    {
        int idx;
        unsigned int dims[] = {utDbl2Int(i),utDbl2Int(j),utDbl2Int(k)};
        
        idx = mxGetSingleIndex(3, m_dims, 3, dims);
        
        if(idx != -1)
        {
            m_pr[idx] = r;
        }
        else
        {
            mwArray tmpI(i), tmpJ(j), tmpK(k), tmpR(r);
            IndexAssign(tmpI, tmpJ, tmpK, tmpR);
        }
    }

    void IndexAssign(const mwArray &i, const mwArray &a)
    {
        mwArray tempArray((mwArray)(*this));
        tempArray(i) = a;
        SetArray(tempArray);
    }

    void IndexAssign(const mwArray &i, const mwArray &j, const mwArray &a)
    {
        mwArray tempArray((mwArray)(*this));
        tempArray(i, j) = a;
        SetArray(tempArray);
    }

    void IndexAssign(const mwArray &i, const mwArray &j, const mwArray &k, const mwArray &a)
    {
        mwArray tempArray((mwArray)(*this));
        tempArray(i, j, k) = a; 
        SetArray(tempArray);
    }

    void IndexDelete(const mwArray &i)
    {
        mwArray tempArray((mwArray)(*this));
        tempArray(i) = mwEmptySqBracket();
        SetArray(tempArray);
    }

    void IndexDelete(const mwArray &i, const mwArray &j)
    {
        mwArray tempArray((mwArray)(*this));
        tempArray(i, j) = mwEmptySqBracket();
        SetArray(tempArray);
    }

    void IndexDelete(const mwArray &i, const mwArray &j, const mwArray &k)
    {
        mwArray tempArray((mwArray)(*this));
        tempArray(i, j, k) = mwEmptySqBracket();
        SetArray(tempArray);
    }

    void IndexDelete(double i)
    {
        mwArray tempArray(i);
        IndexDelete(tempArray);
    }
    
    void IndexDelete(double i, double j)
    {
        mwArray tempArray_i(i), tempArray_j(j);
        IndexDelete(tempArray_i, tempArray_j);
    }
    
    void IndexDelete(double i, double j, double k)
    {
        mwArray tempArray_i(i), tempArray_j(j), tempArray_k(k);
        IndexDelete(tempArray_i, tempArray_j, tempArray_k);
    }


    void MarshalIn(mwArray *a)
    {
        mwArray temp(*a);
        temp.Unshare();
        SetArray(temp);
    }

    void MarshalOut(mwArray *a)
    {
        if(m_init)
        {
            *a = (mwArray)*this;
        }
        else
        {
	    /* ERROR */
	}
	
        Cleanup();
    }

#endif
} C3;

/* C stuff */
#ifdef __cplusplus
    extern "C" {
#endif

#if defined(MW_INLINE)

/* Initialize a Cmatrix */
CINLINE void mclInitializeC3(C3 *x)
{
    memset(&(x->m_dims), 0, 3*sizeof(unsigned int));
    x->m_pr   = NULL;
    x->m_init = false;
    x->m_pshadow = NULL;
} 

CINLINE void mclDestroyC3(C3 *x)
{
    if(x->m_pshadow != NULL)
    {
        mxDecrementRefCount(x->m_pshadow);
        if (mxGetRefCount(x->m_pshadow) <= 0) {
            mclDestroyArray( x->m_pshadow );
        }
        x->m_pr = NULL;
    }
    
    if(x->m_pr != NULL)
    {
        free(x->m_pr);
        x->m_pr = NULL;
    }

    memset(&(x->m_dims), 0, 3*sizeof(unsigned int));
    x->m_init = false;
    x->m_pshadow = NULL;
}

CINLINE void mclSetC3(C3 *ct, mxArray *a)
{
    /* cleanup existing cmatrix */
    if(a != ct->m_pshadow)
    {
        mclDestroyC3(ct);

        /* increment ref count on array */
        if (mxGetRefCount(a) != 0) 
        {
            a = mxCreateSharedCopy(a);           
        }
        mxIncrementRefCount(a);
    }

    /* set important values */
 
    /* get dims. if not 3 fill with 0's */
    if(mxGetNumberOfDimensions(a) == 3)
    {
        memcpy(&(ct->m_dims), mxGetDimensions(a), 3*sizeof(unsigned int));
    }
    else if(mxGetNumberOfDimensions(a) == 2)
    {
        ct->m_dims[0] = mxGetM(a);
        ct->m_dims[1] = mxGetN(a);
        ct->m_dims[2] = 1;
    }
    else
    {
        utAssert(mxGetNumberOfDimensions(a) == 1);
        ct->m_dims[0] = mxGetM(a);
        ct->m_dims[1] = 1;
        ct->m_dims[2] = 1;
    }

    ct->m_pr = mxGetPr(a);

    /* set init and shadow */
    ct->m_init = true;
    ct->m_pshadow = a;
}

CINLINE mxArray *mclC3ToArray(C3 *ct)
{
    /* do we need to increment ref count in this case? */
    if(ct->m_init && (ct->m_pshadow != NULL))
    {
        return ct->m_pshadow;
    }
    else if(ct->m_init)
    {
        /* keeps mxCreateDoubleMatrix from allocing new pr */
        mxArray *a = mxCreateDoubleMatrix(0,0,mxREAL);
        mxSetDimensions(a, (const int *)&(ct->m_dims), 3);        
        mxSetPr(a,ct->m_pr);

        return a;
    }
    else
    {
        /* ERROR */
        return NULL;
    }
}

CINLINE void mclIndexAssignC31Array(C3 *ct, mxArray *i, mxArray *a)
{
    mxArray *pa = NULL;
    pa = mclC3ToArray(ct);
    utAssert(pa != NULL);

    mclArrayAssign1(&pa, a, i);
    mclAdjustRefCount(ct->m_pshadow, pa);
    mclSetC3(ct, pa);
}

CINLINE void mclIndexAssignC32Array(C3 *ct, mxArray *i, mxArray *j, mxArray *a)
{
    mxArray *pa = NULL;
    pa = mclC3ToArray(ct);
    utAssert(pa != NULL);

    mclArrayAssign2(&pa, a, i, j);
    mclAdjustRefCount(ct->m_pshadow, pa);
    mclSetC3(ct, pa);
}

CINLINE void mclIndexAssignC33Array(C3 *ct, mxArray *i, mxArray *j, mxArray *k, mxArray *a)
{
    mxArray *pa = NULL;
    pa = mclC3ToArray(ct);
    utAssert(pa != NULL);

    mlfIndexAssign(&pa, "(?,?,?)", i, j, k, a);
    mclAdjustRefCount(ct->m_pshadow, pa);
    mclSetC3(ct, pa);
}

CINLINE void mclIndexAssignC31(C3 *ct, double i, double r)
{
    int idx;
    unsigned int dims[1] = {utDbl2Int(i)};

    idx = mxGetSingleIndex(3, ct->m_dims, 1, dims);
    
    if(idx != -1)
    {
        ct->m_pr[idx] = r;
    }
    else
    {
        mclIndexAssignC31Array(ct, mlfScalar(i), mlfScalar(r));
    }
}

CINLINE void mclIndexAssignC32(C3 *ct, double i, double j, double r)
{
    int idx;
    unsigned int dims[2] = {utDbl2Int(i), utDbl2Int(j)};
    
    idx = mxGetSingleIndex(3, ct->m_dims, 2, dims);
    
    if(idx != -1)
    {
        ct->m_pr[idx] = r;
    }
    else
    {
        mclIndexAssignC32Array(ct, mlfScalar(i), mlfScalar(j), mlfScalar(r));
    }
}

CINLINE void mclIndexAssignC33(C3 *ct, double i, double j, double k, double r)
{
    int idx;
    unsigned int dims[3] = {utDbl2Int(i), utDbl2Int(j), utDbl2Int(k)};
    
    idx = mxGetSingleIndex(3, ct->m_dims, 3, dims);
    
    if(idx != -1)
    {
        ct->m_pr[idx] = r;
    }
    else
    {
        mclIndexAssignC33Array(ct, mlfScalar(i), mlfScalar(j), mlfScalar(k), mlfScalar(r));       
    }
}

void mclIndexDeleteC31Array(C3 *ct, mxArray *i)
{
    mxArray *pa = NULL;
    pa = mclC3ToArray(ct);
    utAssert(pa != NULL);

    mlfIndexDelete(&pa, "(?)", i);
    mclAdjustRefCount(ct->m_pshadow, pa);
    mclSetC3(ct, pa);
}

void mclIndexDeleteC32Array(C3 *ct, mxArray *i, mxArray *j)
{
    mxArray *pa = NULL;
    pa = mclC3ToArray(ct);
    utAssert(pa != NULL);

    mlfIndexDelete(&pa, "(?,?)", i, j);
    mclAdjustRefCount(ct->m_pshadow, pa);
    mclSetC3(ct, pa);
}

void mclIndexDeleteC33Array(C3 *ct, mxArray *i, mxArray *j, mxArray *k)
{
    mxArray *pa = NULL;
    pa = mclC3ToArray(ct);
    utAssert(pa != NULL);

    mlfIndexDelete(&pa, "(?,?,?)", i, j, k);
    mclAdjustRefCount(ct->m_pshadow, pa);
    mclSetC3(ct, pa);
}

void mclIndexDeleteC31(C3 *ct, double i)
{
    mclIndexDeleteC31Array(ct, mlfScalar(i));
}

void mclIndexDeleteC32(C3 *ct, double i, double j)
{
    mclIndexDeleteC32Array(ct, mlfScalar(i), mlfScalar(j));
}

void mclIndexDeleteC33(C3 *ct, double i, double j, double k)
{
    mclIndexDeleteC33Array(ct, mlfScalar(i), mlfScalar(j), mlfScalar(k));
}

CINLINE void mclMarshalInC3(C3 *ct, mxArray **a)
{
    mxUnshareArray(*a, DEEP);
    mclSetC3(ct, *a);
}

CINLINE void mclMarshalOutC3(C3 *ct, mxArray **a)
{
    if(ct->m_init)
    {
        mlfAssign(a, mclC3ToArray(ct));
    }
    else
    {
        /* ERROR */
    }

    mclDestroyC3(ct);
}

#else
    IMPORT void mclInitializeC3(C3 *x);

    IMPORT void mclDestroyC3(C3 *x);

#   define mclDestroyC3(x) mclDestroyC3(&x)

    IMPORT void mclSetC3(C3 *ct, mxArray *a);

#   define mclAssignC3(ct, a) mclSetC3(ct, a)

    IMPORT mxArray *mclC3ToArray(C3 *ct);

#   define mclC3ToArray(ct) mclC3ToArray(&ct)

    IMPORT void mclIndexAssignC31(C3 *ct, double i, double r);

    IMPORT void mclIndexAssignC32(C3 *ct, double i, double j, double r);

    IMPORT void mclIndexAssignC33(C3 *ct, double i, double j, double k, double r);


    IMPORT void mclIndexAssignC31Array(C3 *ct, mxArray *i, mxArray *a);

    IMPORT void mclIndexAssignC32Array(C3 *ct, mxArray *i, mxArray *j, mxArray *a);

    IMPORT void mclIndexAssignC33Array(C3 *ct, mxArray *i, mxArray *j, mxArray *k, mxArray *a);


    IMPORT void mclIndexDeleteC31(C3 *ct, double i);

    IMPORT void mclIndexDeleteC32(C3 *ct, double i, double j);

    IMPORT void mclIndexDeleteC33(C3 *ct, double i, double j, double k);


    IMPORT void mclIndexDeleteC31Array(C3 *ct, mxArray *i);

    IMPORT void mclIndexDeleteC32Array(C3 *ct, mxArray *i, mxArray *j);

    IMPORT void mclIndexDeleteC33Array(C3 *ct, mxArray *i, mxArray *j, mxArray *k);


    IMPORT void mclMarshalInC3(C3 *ct, mxArray **a);

    IMPORT void mclMarshalOutC3(C3 *ct, mxArray **a);


#endif /* MW_INLINE */

#ifdef __cplusplus
    }
#endif

#endif /* !defined(MW_C3_H) */




/**
 * Cmatrix.h: interface for the Cmatrix class.
 *
 * ////////////////////////////////////////////////////////////////////
 */

#if !defined(MW_CMATRIX_H)
#define MW_CMATRIX_H

#if defined(__cplusplus) && !defined(MW_OUTOFLINE)
class mwArray;
#endif

typedef struct Cmatrix  
{
    mxArray        *m_pshadow;
    double	   *m_pr;
    unsigned int    m_m;
    unsigned int    m_n;
    bool            m_init;

#if defined(__cplusplus) && !defined(MW_OUTOFLINE)
    mwArray        *m_cppshadow;
public:
    Cmatrix() : m_m(0), m_n(0), m_pr(0), m_init(false), m_cppshadow(0) {}

    ~Cmatrix()	    /* Not virtual on purpose. Do not change */
    {
	Cleanup();
    }

    void Cleanup()
    {
        if(m_cppshadow)
	{
            m_cppshadow->~mwArray();
            m_cppshadow->freeMem();
            m_pr = 0;
	}
        
        if(m_pr)
        {
            /* utMalloc/utFree */
            delete [] m_pr;
            m_pr = 0;
        }

        m_m = 0;
        m_n = 0;
        m_cppshadow = 0;
        m_init = false;
    }

    /* Conversion ctor */
    Cmatrix(mwArray &a)
    {
        SetArray(a);
    }

    /**
     * Conversion operators
     */
    Cmatrix &operator= (const mwArray &other)
    {
        MarshalIn(const_cast<mwArray *>(&other));
	return *this;
    }

    void SetArray(const mwArray &a)
    {
        Cleanup();

        /* set shadow using placement new */
	m_cppshadow = new(1) mwArray(a);
        
        /* set important values */
	m_m = mxGetM(m_cppshadow->GetData());
	m_n = mxGetN(m_cppshadow->GetData());
	m_pr = mxGetPr(m_cppshadow->GetData());

        /* set init */
        m_init = true;
    }

    operator mwArray()
    {
        if(m_init && m_cppshadow)
        {
            return mwArray( *m_cppshadow );
        }
        else if(m_init)
        {
            return mwArray( m_m, m_n, m_pr, NULL );
        }
        else
        {
            /* ERROR: Throw Exception */
            return mwArray();
        }
    }

    void IndexAssign(const mwArray &i, const mwArray &a)
    {
        mwArray tempArray((mwArray)(*this));
        tempArray(i) = a;
        SetArray(tempArray);
    }

    void IndexAssign(const mwArray &i, const mwArray &j, const mwArray &a)
    {
        mwArray tempArray((mwArray)(*this));
        tempArray(i, j) = a;
        SetArray(tempArray);
    }


    void IndexAssign(double i, double r)
    { 
        int idx;
        if(i <= (m_m * m_n))
        {
            idx = utDbl2Int(i);
            m_pr[idx-1] = r;
        }
        else
        {
            mwArray tmpI(i), tmpR(r);
            IndexAssign(tmpI, tmpR);
        }
    }

    void IndexAssign(double i, double j, double r)
    { 
        int idx;
        unsigned int dims[2];
        const unsigned int actualdims[] = {m_m, m_n};
        
        dims[0] = utDbl2Int(i);
        dims[1] = utDbl2Int(j);
        
        idx = mxGetSingleIndex(2, actualdims, 2, dims);
        
        if(idx != -1)
        {
            m_pr[idx] = r;
        }
        else
        {
            mwArray tmpI(i), tmpJ(j), tmpR(r);
            IndexAssign(tmpI, tmpJ, tmpR);            
        }
    }
    
    void IndexDelete(const mwArray &i)
    {
        mwArray tempArray((mwArray)(*this));
        tempArray(i) = mwEmptySqBracket();
        SetArray(tempArray);
    }
    
    void IndexDelete(const mwArray &i, const mwArray &j)
    {
        mwArray tempArray((mwArray)(*this));
        tempArray(i, j) = mwEmptySqBracket();
        SetArray(tempArray);
    }

    void IndexDelete(double i)
    {
        mwArray tempArray(i);
        IndexDelete(tempArray);
    }
    
    void IndexDelete(double i, double j)
    {
        mwArray tempArray_i(i), tempArray_j(j);
        IndexDelete(tempArray_i, tempArray_j);
    }

    void MarshalIn(mwArray *a)
    {
        mwArray temp(*a);
        temp.Unshare();
        SetArray(temp);
    }

    void MarshalOut(mwArray *a)
    {
        if(m_init)
        {
            *a = (mwArray)*this;
        }
        else
        {
            /* ERROR */
        }

        Cleanup();
    }

#endif

}Cmatrix;

/* C stuff */
#ifdef __cplusplus
    extern "C" {
#endif

#if defined(MW_INLINE)

/* Initialize a Cmatrix */
CINLINE void mclInitializeCmatrix(Cmatrix *x)
{
    x->m_m    = 0;
    x->m_n    = 0; 
    x->m_pr   = NULL; 
    x->m_init = false;
    x->m_pshadow = NULL;
} 

CINLINE void mclDestroyCmatrix(Cmatrix *x)
{
    if(x->m_pshadow != NULL)
    {
        mxDecrementRefCount(x->m_pshadow);
        if (mxGetRefCount(x->m_pshadow) <= 0) {
            mclDestroyArray( x->m_pshadow );
        }
	x->m_pr = NULL;
    }

    if(x->m_pr != NULL)
    {
        free(x->m_pr);
	x->m_pr = NULL;
    }

    x->m_m    = 0;
    x->m_n    = 0; 
    x->m_init = false;
    x->m_pshadow = NULL;
} 

CINLINE void mclSetCmatrix(Cmatrix *cm, mxArray *a)
{
    /* cleanup existing cmatrix */
    if(a != cm->m_pshadow)
    {
        mclDestroyCmatrix(cm);

        /* increment ref count on array */
        if (mxGetRefCount(a) != 0) 
        {
            a = mxCreateSharedCopy(a);           
        }
        mxIncrementRefCount(a); 
    }

    /* set important values */
    cm->m_m = mxGetM(a);
    cm->m_n = mxGetN(a);
    cm->m_pr = mxGetPr(a);

    /* set init and shadow */
    cm->m_init = true;
    cm->m_pshadow = a;
}

CINLINE mxArray *mclCmatrixToArray(Cmatrix *cm)
{
    /* do we need to increment ref count in this case? */
    if(cm->m_init && (cm->m_pshadow != NULL))
    {
        return cm->m_pshadow;
    }
    else if(cm->m_init)
    {
        /* keeps mxCreateDoubleMatrix from allocing new pr */
        mxArray *a = mxCreateDoubleMatrix(0,0,mxREAL);
        mxSetM(a,cm->m_m);
        mxSetN(a,cm->m_n);
        mxSetPr(a,cm->m_pr);
    
        return a;
    }
    else
    {
        /* ERROR */
        return NULL;
    }
}

CINLINE void mclIndexAssignCmatrix1Array(Cmatrix *cm, mxArray *i, mxArray *a)
{
    mxArray *pa = NULL;
    pa = mclCmatrixToArray(cm);
    utAssert(pa != NULL);

    mclArrayAssign1(&pa, a, i);
    mclAdjustRefCount(cm->m_pshadow, pa);
    mclSetCmatrix(cm, pa);
}

CINLINE void mclIndexAssignCmatrix2Array(Cmatrix *cm, mxArray *i, mxArray *j, mxArray *a)
{
    mxArray *pa = NULL;
    pa = mclCmatrixToArray(cm);
    utAssert(pa != NULL);

    mclArrayAssign2(&pa, a, i, j);
    mclAdjustRefCount(cm->m_pshadow, pa);
    mclSetCmatrix(cm, pa);
}

CINLINE void mclIndexAssignCmatrix1(Cmatrix *cm, double i, double r)
{
    int idx;
    if(i <= (cm->m_m * cm->m_n))
    {
        idx = utDbl2Int(i);
        cm->m_pr[idx-1] = r;
    }
    else
    {
        mclIndexAssignCmatrix1Array(cm, mlfScalar(i), mlfScalar(r));
    }
}

CINLINE void mclIndexAssignCmatrix2(Cmatrix *cm, double i, double j, double r)
{
    int idx;
    unsigned int dims[2];
    const unsigned int actualdims[] = {cm->m_m, cm->m_n};

    dims[0] = utDbl2Int(i);
    dims[1] = utDbl2Int(j);

    idx = mxGetSingleIndex(2, actualdims, 2, dims);
    
    if(idx != -1)
    {
        cm->m_pr[idx] = r;
    }
    else
    {
        mclIndexAssignCmatrix2Array(cm, mlfScalar(i), mlfScalar(j), mlfScalar(r));
    }
}

void mclIndexDeleteCmatrix1Array(Cmatrix *cm, mxArray *i)
{
    mxArray *pa = NULL;
    pa = mclCmatrixToArray(cm);
    utAssert(pa != NULL);

    mlfIndexDelete(&pa, "(?)", i);
    mclAdjustRefCount(cm->m_pshadow, pa);
    mclSetCmatrix(cm, pa);
}

void mclIndexDeleteCmatrix2Array(Cmatrix *cm, mxArray *i, mxArray *j)
{
    mxArray *pa = NULL;
    pa = mclCmatrixToArray(cm);
    utAssert(pa != NULL);

    mlfIndexDelete(&pa, "(?,?)", i, j);
    mclAdjustRefCount(cm->m_pshadow, pa);
    mclSetCmatrix(cm, pa);
}

void mclIndexDeleteCmatrix1(Cmatrix *cm, double i)
{
    mclIndexDeleteCmatrix1Array(cm, mlfScalar(i));
}

void mclIndexDeleteCmatrix2(Cmatrix *cm, double i, double j)
{
    mclIndexDeleteCmatrix2Array(cm, mlfScalar(i), mlfScalar(j));
}

CINLINE void mclMarshalInCmatrix(Cmatrix *cm, mxArray **a)
{
    mxUnshareArray(*a, DEEP);
    mclSetCmatrix(cm, *a);
}

CINLINE void mclMarshalOutCmatrix(Cmatrix *cm, mxArray **a)
{
    if(cm->m_init)
    {
        mlfAssign(a, mclCmatrixToArray(cm));
    }
    else
    {
        /* ERROR */
    }

    mclDestroyCmatrix(cm);
}

#else
    IMPORT void mclInitializeCmatrix(Cmatrix *x);

    IMPORT void mclDestroyCmatrix(Cmatrix *x);

#   define mclDestroyCmatrix(x) mclDestroyCmatrix(&x)

    IMPORT void mclSetCmatrix(Cmatrix *cm, mxArray *a);

#   define mclAssignCmatrix(cm, a) mclSetCmatrix(cm, a)

    IMPORT mxArray *mclCmatrixToArray(Cmatrix *cm);

#   define mclCmatrixToArray(x) mclCmatrixToArray(&x)

    IMPORT void mclIndexAssignCmatrix1(Cmatrix *cm, double i, double r);

    IMPORT void mclIndexAssignCmatrix2(Cmatrix *cm, double i, double j, double r);


    IMPORT void mclIndexAssignCmatrix1Array(Cmatrix *cm, mxArray *i, mxArray *a);

    IMPORT void mclIndexAssignCmatrix2Array(Cmatrix *cm, mxArray *i, mxArray *j, mxArray *a);


    IMPORT void mclIndexDeleteCmatrix1(Cmatrix *cm, double i);

    IMPORT void mclIndexDeleteCmatrix2(Cmatrix *cm, double i, double j);


    IMPORT void mclIndexDeleteCmatrix1Array(Cmatrix *cm, mxArray *i);

    IMPORT void mclIndexDeleteCmatrix2Array(Cmatrix *cm, mxArray *i, mxArray *j);


    IMPORT void mclMarshalInCmatrix(Cmatrix *cm, mxArray **a);

    IMPORT void mclMarshalOutCmatrix(Cmatrix *cm, mxArray **a);


#endif /* MW_INLINE */

#ifdef __cplusplus
    }
#endif

#endif /* !defined(MW_CMATRIX_H) */




/**
 * Cstring.h: interface for the Cstring class.
 *
 * ////////////////////////////////////////////////////////////////////
 */

#if !defined(MW_CSTRING_H)
#define MW_CSTRING_H

#if defined(__cplusplus) && !defined(MW_OUTOFLINE)
class mwArray;
#endif

typedef struct Cstring  
{
    mxArray        *m_pshadow;
    unsigned int    m_len;
    unsigned short *m_pchars;
    bool	    m_init;

#if defined(__cplusplus) && !defined(MW_OUTOFLINE)
    mwArray       *m_cppshadow;
public:
    Cstring() : m_len(0), m_pchars(0), m_init(false), m_cppshadow(0) {}

    ~Cstring()	    /* Not virtual on purpose. Do not change */
    {
        Cleanup();
    }

    void Cleanup()
    {
        if(m_cppshadow)
	{ 
            m_cppshadow->~mwArray();
            m_cppshadow->freeMem();
            m_pchars = 0;   
	}

        if(m_pchars)
        {
	    delete [] m_pchars;
	    m_pchars = 0;
        }

        m_cppshadow = 0;
        m_init = false;
    }

    /* Conversion ctor */
    Cstring(mwArray &a)
    {
        SetArray(a);
    }

    /* Conversion operators */
    Cstring &operator= (const mwArray &other)
    {
        MarshalIn(const_cast<mwArray*>(&other));
	return *this;
    }

    void SetArray(const mwArray &a)
    {
        /* cleanup existing contents */
        Cleanup();

        /* set shadow using placement new */
	m_cppshadow = new(1) mwArray(a);

        /* set important values */
	m_len = mxGetN(m_cppshadow->GetData());	
	m_pchars = mxGetChars(m_cppshadow->GetData());	

        /* set init */
        m_init = true;

    }

    operator mwArray()
    {
        if(m_init && m_cppshadow)
        {
            return mwArray( *m_cppshadow);
        }
        else if(m_init)
        {
            mxArray *a = mxCreateString("");
            mxSetM(a, 1 );
            mxSetN(a, m_len );
            mxSetData(a, m_pchars);

            return mwArray(a);
        }
        else
        {
            /* ERROR: Throw Exception */
            return mwArray();
        }
    }

    void IndexAssign(double i, const mwArray &r)
    {
        int idx;
        if((i <= m_len) && (mxGetN(r.GetData()) == 1))
        {
            idx = utDbl2Int(i);
            m_pchars[idx-1] = *mxGetChars(r.GetData());
        }
        else
        {
            mwArray tmpI(i);
            IndexAssign(tmpI, r);
        }
    }

    void IndexAssign(const mwArray &i, const mwArray &a)
    {
        mwArray tempArray((mwArray)(*this));
        tempArray(i) = a;
        SetArray(tempArray);
    }
    
    void IndexDelete(const mwArray &i)
    {
        mwArray tempArray((mwArray)(*this));
        tempArray(i) = mwEmptySqBracket();
        SetArray(tempArray);
    }

    void IndexDelete(double i)
    {
        mwArray tempArray(i);
        IndexDelete(tempArray);
    }

    void MarshalIn(mwArray *a)
    {
        mwArray temp(*a);
        temp.Unshare();
        SetArray(temp);
    }

    void MarshalOut(mwArray *a)
    {
	/* check ownership */
        if(m_init)
        {
            *a = (mwArray)*this;
        }
        else
        {
            /* ERROR */
        }

        Cleanup();
    }

#endif
} Cstring;

/* C stuff */
#ifdef __cplusplus
    extern "C" {
#endif

#if defined(MW_INLINE)

/* Initialize a Cstring */
CINLINE void mclInitializeCstring(Cstring *x)
{
    x->m_len =  0;
    x->m_pchars = NULL;
    x->m_init = false;
    x->m_pshadow = NULL;
} 

CINLINE void mclDestroyCstring(Cstring *x)
{
    if(x->m_pshadow != NULL)
    {
        mxDecrementRefCount(x->m_pshadow);
        if (mxGetRefCount(x->m_pshadow) <= 0) {
            mclDestroyArray( x->m_pshadow );
        }
	x->m_pchars = NULL;
    }

    if(x->m_pchars != NULL)
    {
	utFree(x->m_pchars);
	x->m_pchars = NULL;
    }

    x->m_len    = 0;
    x->m_init = false;
    x->m_pshadow = NULL;
}

CINLINE void mclSetCstring(Cstring *cs, mxArray *a)
{
    if(a != cs->m_pshadow)
    {
        mclDestroyCstring(cs);

        /* increment ref count on array */
        if (mxGetRefCount(a) != 0) 
        {
            a = mxCreateSharedCopy(a);           
        }
        mxIncrementRefCount(a);
    }

    /* set important values */
    cs->m_len = mxGetN(a);
    cs->m_pchars = mxGetChars(a);

    /* set init and shadow */
    cs->m_init = true;
    cs->m_pshadow = a;
}

CINLINE mxArray *mclCstringToArray(Cstring *cs)
{
    if(cs->m_init && (cs->m_pshadow != NULL))
    {
        return cs->m_pshadow;
    }
    else if(cs->m_init)
    {
        mxArray *a = mxCreateString("");
        mxSetM(a, 1 );
        mxSetN(a, cs->m_len );
        mxSetData(a, cs->m_pchars);
    
        return a;
    }
    else
    {
        /* ERROR */
        return NULL;
    }
}

CINLINE void mclIndexAssignCstringArray(Cstring *cs, mxArray *i, mxArray *str)
{
    mxArray *pa = NULL;
    pa = mclCstringToArray(cs);
    utAssert(pa != NULL);
    
    mclArrayAssign1(&pa, str, i);
    mclAdjustRefCount(cs->m_pshadow, pa);
    mclSetCstring(cs, pa);
}

CINLINE void mclIndexAssignCstring(Cstring *cs, double i, mxArray *str)
{
    int idx;
    if((i <= cs->m_len) && (mxGetN(str) == 1))
    {
        idx = utDbl2Int(i);
        cs->m_pchars[idx-1] = *mxGetChars(str);
    }
    else
    {
        mclIndexAssignCstringArray(cs, mlfScalar(i), str);
    }
}

void mclIndexDeleteCstringArray(Cstring *cs, mxArray *i)
{
    mxArray *pa = NULL;
    pa = mclCstringToArray(cs);
    utAssert(pa != NULL);
    
    mlfIndexDelete(&pa, "(?)", i);
    mclAdjustRefCount(cs->m_pshadow, pa);
    mclSetCstring(cs, pa);
}

void mclIndexDeleteCstring(Cstring *cs, double i)
{
    mclIndexDeleteCstringArray(cs, mlfScalar(i));
}

CINLINE void mclMarshalInCstring(Cstring *cs, mxArray **a)
{
    mxUnshareArray(*a, DEEP);
    mclSetCstring(cs, *a);
}

CINLINE void mclMarshalOutCstring(Cstring *cs, mxArray **a)
{
    if(cs->m_init)
    {
        mlfAssign(a, mclCstringToArray(cs));
    }
    else
    {
        /* ERROR */
    }

    mclDestroyCstring(cs);
}

#else
    IMPORT void mclInitializeCstring(Cstring *x);

    IMPORT void mclDestroyCstring(Cstring *x);

#   define mclDestroyCstring(x) mclDestroyCstring(&x)

    IMPORT void mclSetCstring(Cstring *cs, mxArray *a);

#   define mclAssignCstring(cs, a) mclSetCstring(cs, a)

    IMPORT void mclIndexAssignCstring(Cstring *cs, double i, mxArray *str);


    IMPORT void mclIndexAssignCstringArray(Cstring *cs, mxArray *i, mxArray *str);


    IMPORT void mclIndexDeleteCstring(Cstring *cs, double i);


    IMPORT void mclIndexDeleteCstringArray(Cstring *cs, mxArray *i);


    IMPORT void mclMarshalInCstring(Cstring *cs, mxArray **a);

    IMPORT void mclMarshalOutCstring(Cstring *cs, mxArray **a);


#endif /* MW_INLINE */
#ifdef __cplusplus
    }
#endif
#endif /* !defined(MW_CSTRING_H) */


#endif /* mcl_h */
