/*
 * @(#)mclmcr.h    generated by: makeheader 4.21  Sat Aug 21 00:38:48 2004
 *
 *		built from:	../../src/include/copyright.h
 *				../../src/include/pragma_interface.h
 *				./arraydata.cpp
 *				./arrayfactory.cpp
 *				./arrayref.cpp
 *				./charbuffer.cpp
 *				./mclcpp.cpp
 *				./mclmcr.cpp
 *				./mclmcrmcc.cpp
 *				./mwarray_common.cpp
 *				./objallocator.cpp
 */

#ifndef mclmcr_h
#define mclmcr_h


/*
 * Copyright 1984-2003 The MathWorks, Inc.
 * All Rights Reserved.
 */



/* Copyright 2003 The MathWorks, Inc. */

/*
 * Prevent g++ from making copies of vtable and typeinfo data
 * in every compilation unit.  By allowing for only one, we can
 * save space and prevent some situations where the linker fails
 * to coalesce them properly into a single entry.
 *
 * References:
 *    http://gcc.gnu.org/onlinedocs/gcc/Vague-Linkage.html#Vague%20Linkage
 *    http://gcc.gnu.org/onlinedocs/gcc/C---Interface.html
 */

#ifdef __cplusplus
#  ifdef GLNX86
#    pragma interface
#  endif
#endif



#include <stdarg.h>
#include <string.h>
#include "matrix.h"


typedef void* HMCRINSTANCE;
typedef int (*mclOutputHandlerFcn)(const char *s);

/* All the types of components we can generate code for. These values 
 * determine how the component initializes itself.
 */
typedef enum
{
    NoObjectType,
    COMObject,
    JavaObject,
    DotNetObject
} mccComponentType;

typedef enum {
  ExeTarget,
  LibTarget,
  MexTarget,
  SfunTarget,
  AnyTarget
} mccTargetType;



#ifdef __cplusplus
extern "C"
{
#endif

 
extern void mclSetErrorHandler(HMCRINSTANCE inst, mclOutputHandlerFcn eh);

 
extern void mclSetPrintHandler(HMCRINSTANCE inst, mclOutputHandlerFcn ph);


#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
    extern "C" {
#endif


extern void mclAddPathMacro(const char* macro, const char* expansion);


extern void mclRemovePathMacro(const char* macro);


#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
    extern "C" {
#endif


extern bool mclInitializeApplication(const char **options, int count);


extern bool mclTerminateApplication(void);


extern void mclInhibitShutdown(void);


extern void mclUninhibitShutdown(void);


extern bool mclGetDispatcherPathID(HMCRINSTANCE inst, void **path);


extern bool mclWhich(HMCRINSTANCE inst, const char* name, char *path, int pathlen);


extern bool mclDirName(HMCRINSTANCE inst, const char* name, char *path,
		int pathlen);


extern bool mclIsDemoMCR(HMCRINSTANCE inst, bool *isdemo);


extern char **mclGetInstancePath(HMCRINSTANCE inst);


extern const char *mclGetInstanceCWD(HMCRINSTANCE inst);


extern bool mclSwapPath(char ***oldPath, char **old_cwd, char **newPath,
		 const char *current_directory);


extern bool mclChangeDirectory(HMCRINSTANCE inst, const char* dir);


extern bool mclChangeDirectoryFeval(HMCRINSTANCE inst, const char* dir);


extern bool mclAddPath(HMCRINSTANCE inst, const char* dir);


extern bool mclRemovePath(HMCRINSTANCE inst, const char* dirName);


extern bool mclAddPath(HMCRINSTANCE inst, const char* dir);


extern mxArray *mclCreateCellArrayFromArrayList(int narray, mxArray *parray[]);

extern bool mclTerminateInstance(HMCRINSTANCE* inst);


extern bool mclPushActivation(HMCRINSTANCE inst);


extern bool mclPopActivation(HMCRINSTANCE inst);

extern const char* mclGetLastErrorMessage(HMCRINSTANCE inst);

extern const char* mclGetLastErrorCode(HMCRINSTANCE inst);

extern bool mclFeval(HMCRINSTANCE inst, const char* name, int nlhs, mxArray** plhs, int nrhs, mxArray** prhs);

extern bool mclMexFeval(HMCRINSTANCE inst, const char* name, int nlhs, mxArray** plhs, int nrhs, const mxArray** prhs);

extern bool mclMlfVFeval(HMCRINSTANCE inst, const char* name, int nargout, int fnout, int fnin, va_list ap);

extern bool mclMlfFeval(HMCRINSTANCE inst, const char* name, int nargout, int fnout, int fnin, ...);

extern bool mclInitializeComponentInstance(HMCRINSTANCE* inst,
                                     const unsigned char *public_data,
                                     const char *name_data,
                                     const char *root_data,
                                     const unsigned char *session_data,
                                     const char **matlab_path_data,
                                     int matlab_path_data_count,
                                     const char **class_path_data,
                                     int class_path_data_count,
				     const char *mcr_runtime_options[],
				     int mcr_runtime_option_count,
				     bool replace_path,
				     mccComponentType ctype,
				     mccTargetType ttype,
				     const char *path_to_component,
			             mclOutputHandlerFcn error_handler,
				     mclOutputHandlerFcn print_handler);

extern int mclMain(HMCRINSTANCE inst, int argc, const char* argv[],
		      const char* name, int nlhs);


extern void mclWaitForFiguresToDie(HMCRINSTANCE inst);


extern mxArray* mclCreateSharedCopy(mxArray* px);


extern bool mclSetGlobal(HMCRINSTANCE inst, const char* name, mxArray* px);


extern bool mclGetGlobal(HMCRINSTANCE inst, const char* name, mxArray** ppx);


extern mxArray* mclCreateEmptyArray(void);

 
extern int mclGetMaxPathLen(void);

 
extern int mclGetDotNetComponentType(void);

 
extern int mclGetMCCTargetType(bool isLibrary);


extern mxArray* mclCreateSimpleFunctionHandle(mxFunctionPtr fcn);


extern bool mclRegisterExternalFunction(HMCRINSTANCE inst, const char* varname, mxFunctionPtr fcn);


extern int mclGetID(HMCRINSTANCE inst);


extern int mclGetActiveID(void);


extern bool mclmcrInitialize(void);


#ifdef __cplusplus
}
#endif



#include <stdarg.h>
#include "matrix.h"

typedef real64_T mxDouble;
typedef real32_T mxSingle;
typedef int8_T mxInt8;
typedef uint8_T mxUint8;
typedef int16_T mxInt16;
typedef uint16_T mxUint16;
typedef int32_T mxInt32;
typedef uint32_T mxUint32;
#if !defined(__MW_STDINT_H__)
#  if defined( linux ) || defined( __linux ) || defined( __linux__ )
#    include <stdint.h>
     typedef int64_t mxInt64;
     typedef uint64_t mxUint64;
#  elif defined( macintosh ) || defined( __APPLE__ ) || defined( __APPLE_CC__ )
#    if defined( __GNUC__ )
#      include <stdint.h>
       typedef int64_t mxInt64;
       typedef uint64_t mxUint64;
#    endif
#  elif defined( sun ) || defined( __sun )
#    include <inttypes.h>
     typedef int64_t mxInt64;
     typedef uint64_t mxUint64;
#  elif defined( __hpux )
#    include <inttypes.h>
     typedef int64_t mxInt64;
     typedef uint64_t mxUint64;
#  elif defined(_MSC_VER)
     typedef __int64 mxInt64;
     typedef unsigned __int64 mxUint64;
#  elif defined(__BORLANDC__)
     typedef __int64 mxInt64;
     typedef unsigned __int64 mxUint64;
#  elif defined(__WATCOMC__)
     typedef __int64 mxInt64;
     typedef unsigned __int64 mxUint64;
#  elif defined(__LCC__)
     typedef __int64 mxInt64;
     typedef unsigned __int64 mxUint64;
#  endif
#else
   typedef int64_T mxInt64;
   typedef uint64_T mxUint64;
#endif



#define MCLCPP_OK    0
#define MCLCPP_ERR  -1


#ifdef __cplusplus
    extern "C" {
#endif


extern void mclAcquireMutex(void);


extern void mclReleaseMutex(void);


#ifdef __cplusplus
    }
#endif



#ifdef __cplusplus

class mwLock
{
public:
    mwLock()
    {
        mclAcquireMutex();
    }
    virtual ~mwLock()
    {
        mclReleaseMutex();
    }
};

class error_info
{
public:
    virtual int addref() = 0;
    virtual int release() = 0;
    virtual const char* get_message() = 0;
};

#endif



#ifdef __cplusplus
    extern "C" {
#endif


extern int mclcppGetLastError(void** ppv);


extern int mclcppCreateError(void** ppv, const char* msg);


extern void mclcppSetLastError(const char* msg);


extern int mclcppErrorCheck(void);


#ifdef __cplusplus
    }
#endif



#ifdef __cplusplus

#include <exception>

class mwException : public std::exception
{
public:
    mwException() : std::exception()
    {
        m_err = 0;
        mclcppCreateError((void**)&m_err, "Unspecified error");
    }
    mwException(const char* msg) : std::exception()
    {
        m_err = 0;
        mclcppCreateError((void**)&m_err, (msg ? msg : "Unspecified error"));
    }
    mwException(const mwException& e) : std::exception()
    {
        m_err = e.m_err;
        if (m_err)
            m_err->addref();
    }
    mwException(error_info* pe)
    {
        m_err = 0;
        if (pe)
        {
            m_err = pe;
            m_err->addref();
        }
        else
        {
            mclcppCreateError((void**)&m_err, "Unspecified error");
        }
    }
    mwException(error_info* pe, bool bAddRef)
    {
        m_err = 0;
        if (pe)
        {
            m_err = pe;
            if (bAddRef)
                m_err->addref();
        }
        else
        {
            mclcppCreateError((void**)&m_err, "Unspecified error");
        }
    }
    mwException(const std::exception& e) : std::exception()
    {
        m_err = 0;
        mclcppCreateError((void**)&m_err, e.what());
    }
    virtual ~mwException() throw()
    {
        if (m_err)
            m_err->release();
    }
    mwException& operator=(const std::exception& e)
    {
        if (m_err)
            m_err->release();
        mclcppCreateError((void**)&m_err, e.what());
        return *this;
    }
    mwException& operator=(const mwException& e)
    {
        if (m_err)
            m_err->release();
        m_err = e.m_err;
        if (m_err)
            m_err->addref();
        return *this;
    }
    const char *what() const throw()
    {
        return (m_err ? m_err->get_message() : NULL);
    }
    static void raise_error()
    {
        error_info* pe = 0;
        if (mclcppGetLastError((void**)&pe) == MCLCPP_ERR)
            throw mwException();
        throw mwException(pe, false);
    }
    static void check_raise_error()
    {
        if (!mclcppErrorCheck())
            return;
        mwException::raise_error();
    }
protected:
    error_info* m_err;
};

#endif




#ifdef __cplusplus

class char_buffer
{
public:
    virtual int addref() = 0;
    virtual int release() = 0;
    virtual int size() = 0;
    virtual const char* get_buffer() = 0;
    virtual int set_buffer(const char* str) = 0;
    virtual int compare_to(char_buffer* p) = 0;
};

class array_ref
{
public:
    virtual int addref() = 0;
    virtual int release() = 0;
    virtual mxClassID classID() = 0;
    virtual array_ref* deep_copy() = 0;
    virtual array_ref* shared_copy() = 0;
    virtual array_ref* serialize() = 0;
    virtual int element_size() = 0;
    virtual int number_of_elements() = 0;
    virtual int number_of_nonzeros() = 0;
    virtual int maximum_nonzeros() = 0;
    virtual int number_of_dimensions() = 0;
    virtual array_ref* get_dimensions() = 0;
    virtual int number_of_fields() = 0;
    virtual char_buffer* get_field_name(int i) = 0;
    virtual bool is_empty() = 0;
    virtual bool is_sparse() = 0;
    virtual bool is_numeric() = 0;
    virtual bool is_complex() = 0;
    virtual int make_complex() = 0;
    virtual bool equals(array_ref* p) = 0;
    virtual int compare_to(array_ref* p) = 0;
    virtual int hash_code() = 0;
    virtual char_buffer* to_string() = 0;
    virtual array_ref* row_index() = 0;
    virtual array_ref* column_index() = 0;
    virtual array_ref* get(int num_indices, const int* index) = 0;
    virtual array_ref* get(const char* name, int num_indices, const int* index) = 0;
    virtual array_ref* getV(int num_indices, va_list vargs) = 0;
    virtual array_ref* getV(const char* name, int num_indices, va_list vargs) = 0;
    virtual int set(array_ref* p) = 0;
    virtual array_ref* real() = 0;
    virtual array_ref* imag() = 0;
    virtual int get_numeric(mxDouble* x, int len) = 0;
    virtual int get_numeric(mxSingle* x, int len) = 0;
    virtual int get_numeric(mxInt8* x, int len) = 0;
    virtual int get_numeric(mxUint8* x, int len) = 0;
    virtual int get_numeric(mxInt16* x, int len) = 0;
    virtual int get_numeric(mxUint16* x, int len) = 0;
    virtual int get_numeric(mxInt32* x, int len) = 0;
    virtual int get_numeric(mxUint32* x, int len) = 0;
    virtual int get_numeric(mxInt64* x, int len) = 0;
    virtual int get_numeric(mxUint64* x, int len) = 0;
    virtual int get_char(mxChar* x, int len) = 0;
    virtual int get_logical(mxLogical* x, int len) = 0;
    virtual int set_numeric(const mxDouble* x, int len) = 0;
    virtual int set_numeric(const mxSingle* x, int len) = 0;
    virtual int set_numeric(const mxInt8* x, int len) = 0;
    virtual int set_numeric(const mxUint8* x, int len) = 0;
    virtual int set_numeric(const mxInt16* x, int len) = 0;
    virtual int set_numeric(const mxUint16* x, int len) = 0;
    virtual int set_numeric(const mxInt32* x, int len) = 0;
    virtual int set_numeric(const mxUint32* x, int len) = 0;
    virtual int set_numeric(const mxInt64* x, int len) = 0;
    virtual int set_numeric(const mxUint64* x, int len) = 0;
    virtual int set_char(const mxChar* x, int len) = 0;
    virtual int set_logical(const mxLogical* x, int len) = 0;
};

class array_buffer
{
public:
    virtual int addref() = 0;
    virtual int release() = 0;
    virtual int size() = 0;
    virtual array_ref* get(int offset) = 0;
    virtual int set(int offset, array_ref* p) = 0;
    virtual int add(array_ref* pa) = 0;
    virtual int remove(int offset) = 0;
    virtual int clear() = 0;
    virtual array_ref* to_cell(int offset, int len) = 0;
};


#endif



#ifdef __cplusplus

template<typename T>
class mw_auto_ptr_t
{
public:
    mw_auto_ptr_t()
    {
        m_p = 0;
    }
    explicit mw_auto_ptr_t(T* p)
    {
        m_p = p;
        addref();
    }
    mw_auto_ptr_t(T*p, bool bAddRef)
    {
        m_p = p;
        if (bAddRef)
            addref();
    }
    virtual ~mw_auto_ptr_t()
    {
        if (m_p)
            m_p->release();
    }
    void addref()
    {
        if (m_p)
            m_p->addref();
    }
    void release()
    {
        if (m_p)
        {
            m_p->release();
            m_p = 0;
        }
    }
    void attach(T* p, bool bAddRef)
    {
        release();
        m_p = p;
        if (bAddRef)
            addref();
    }
    T* detach()
    {
        T* p = m_p;
        m_p = 0;
        return p;
    }
    T* operator->(void) const
    {
        if (!m_p)
            throw mwException("Null pointer");
        return m_p;
    }
    T** operator&(void)
    {
        release();
        return &m_p;
    }
    operator T*() const
    {
        return m_p;
    }
    mw_auto_ptr_t<T>& operator=(T* p)
    {
        release();
        m_p = p;
        addref();
        return *this;
    }
    mw_auto_ptr_t<T>& operator=(const mw_auto_ptr_t<T>& ptr)
    {
        release();
        m_p = ptr.m_p;
        addref();
        return *this;
    }
    bool operator!() const
    {
        return (m_p == 0);
    }
    operator bool() const
    {
        return (m_p != 0);
    }
    bool operator==(const mw_auto_ptr_t<T>& ptr)
    {
        return (m_p == (T*)ptr);
    }
    bool operator!=(const mw_auto_ptr_t<T>& ptr)
    {
        return (m_p != (T*)ptr);
    }
protected:
    T* m_p;
};

#endif /* ifdef  __cplusplus */



#ifdef __cplusplus
    extern "C" {
#endif


extern int mclCreateCharBuffer(void** ppv, const char* str);


#ifdef __cplusplus
    }
#endif



#ifdef __cplusplus

#include <iostream>

class mwString
{
public:
    mwString()
    {
        if (mclCreateCharBuffer((void**)&m_str, "") == MCLCPP_ERR)
            mwException::raise_error();
    }
    mwString(const char* str)
    {
        if (mclCreateCharBuffer((void**)&m_str, str) == MCLCPP_ERR)
            mwException::raise_error();
    }
    mwString(char_buffer* buff, bool bAddref)
    {
        m_str.attach(buff, bAddref);
    }
    mwString(const mwString& str)
    {
        if (mclCreateCharBuffer((void**)&m_str, str) == MCLCPP_ERR)
            mwException::raise_error();
        if (m_str->set_buffer((const char*)str) == MCLCPP_ERR)
            mwException::raise_error();
    }
    virtual ~mwString(){}
public:
    int Length() const
    {
        return m_str->size();
    }
    operator const char* () const
    {
        return m_str->get_buffer();
    }
    mwString& operator=(const mwString& str)
    {
        if (&str == this)
            return *this;
        if (m_str->set_buffer((const char*)str) == MCLCPP_ERR)
            mwException::raise_error();
        return *this;
    }
    mwString& operator=(const char* str)
    {
        if (m_str->set_buffer(str) == MCLCPP_ERR)
            mwException::raise_error();
        return *this;
    }
    bool operator==(const mwString& str) const
    {
        return (m_str->compare_to(str.m_str) == 0);
    }
    bool operator!=(const mwString& str) const
    {
        return (m_str->compare_to(str.m_str) != 0);
    }
    bool operator<(const mwString& str) const
    {
        return (m_str->compare_to(str.m_str) < 0);
    }
    bool operator<=(const mwString& str) const
    {
        return (m_str->compare_to(str.m_str) <= 0);
    }
    bool operator>(const mwString& str) const
    {
        return (m_str->compare_to(str.m_str) > 0);
    }
    bool operator>=(const mwString& str) const
    {
        return (m_str->compare_to(str.m_str) >= 0);
    }
    friend std::ostream& operator<<(std::ostream& os, const mwString& str)
    {
        os << (const char*)str;
        return os;
    }
private:
    mw_auto_ptr_t<char_buffer> m_str;
};

#endif



#ifdef __cplusplus
    extern "C" {
#endif


extern double mclGetEps(void);


extern double mclGetInf(void);


extern double mclGetNaN(void);


extern bool mclIsFinite(double x);


extern bool mclIsInf(double x);


extern bool mclIsNaN(double x);


extern int mclGetEmptyArray(void** ppv, mxClassID classid);


extern int mclGetMatrix(void** ppv, int num_rows, int num_cols, mxClassID classid, mxComplexity cmplx);


extern int mclGetArray(void** ppv, int num_dims, const int* dims, mxClassID classid, mxComplexity cmplx);


extern int mclGetNumericMatrix(void** ppv, int num_rows, int num_cols, mxClassID mxID, mxComplexity cmplx);


extern int mclGetNumericArray(void** ppv, int num_dims, const int* dims, mxClassID mxID, mxComplexity cmplx);


extern int mclGetScalarDouble(void** ppv, mxDouble re, mxDouble im, mxComplexity cmplx);


extern int mclGetScalarSingle(void** ppv, mxSingle re, mxSingle im, mxComplexity cmplx);


extern int mclGetScalarInt8(void** ppv, mxInt8 re, mxInt8 im, mxComplexity cmplx);


extern int mclGetScalarUint8(void** ppv, mxUint8 re, mxUint8 im, mxComplexity cmplx);


extern int mclGetScalarInt16(void** ppv, mxInt16 re, mxInt16 im, mxComplexity cmplx);


extern int mclGetScalarUint16(void** ppv, mxUint16 re, mxUint16 im, mxComplexity cmplx);


extern int mclGetScalarInt32(void** ppv, mxInt32 re, mxInt32 im, mxComplexity cmplx);


extern int mclGetScalarUint32(void** ppv, mxUint32 re, mxUint32 im, mxComplexity cmplx);


extern int mclGetScalarInt64(void** ppv, mxInt64 re, mxInt64 im, mxComplexity cmplx);


extern int mclGetScalarUint64(void** ppv, mxUint64 re, mxUint64 im, mxComplexity cmplx);


extern int mclGetCharMatrix(void** ppv, int num_rows, int num_cols);


extern int mclGetCharArray(void** ppv, int num_dims, const int* dims);


extern int mclGetScalarChar(void** ppv, mxChar x);


extern int mclGetString(void** ppv, const char* str);


extern int mclGetCharMatrixFromStrings(void** ppv, int m, const char** str);


extern int mclGetLogicalMatrix(void** ppv, int num_rows, int num_cols);


extern int mclGetLogicalArray(void** ppv, int num_dims, const int* dims);


extern int mclGetScalarLogical(void** ppv, mxLogical x);


extern int mclGetCellMatrix(void** ppv, int num_rows, int num_cols);


extern int mclGetCellArray(void** ppv, int num_dims, const int* dims);


extern int mclGetStructMatrix(void** ppv, int num_rows, int num_cols, int nFields, const char** fieldnames);


extern int mclGetStructArray(void** ppv, int num_dims, const int* dims, int nFields, const char** fieldnames);


extern int mclGetNumericSparse(void** ppv, int data_size, const int* rowindex, const int* colindex, const void* rData,
                        const void* iData, int num_rows, int num_cols, int nzmax, mxClassID mxType, mxComplexity cmplx);


extern int mclGetLogicalSparse(void** ppv, int data_size, const int* rowindex, const int* colindex, const mxLogical* rData,
                        int num_rows, int num_cols, int nzmax);


extern int mclDeserializeArray(void** ppv, void** ppa);


extern int mclcppGetArrayBuffer(void** ppv, int size);


extern int mclcppFeval(HMCRINSTANCE inst, const char* name, int nargout, void** lhs, void* rhs);


#ifdef __cplusplus
    }
#endif


#ifdef __cplusplus
    extern "C" {
#endif

extern bool mclInitializeInstance(HMCRINSTANCE* inst);


#ifdef __cplusplus
    }
#endif

#endif /* mclmcr_h */
