/*
 * @(#)rt_matrx.h    generated by: makeheader 4.21  Wed Aug 18 04:08:56 2004
 *
 *		built from:	rt_matrx.c
 */

#ifndef rt_matrx_h
#define rt_matrx_h


/*
 * Copyright 1994-2003 The MathWorks, Inc.
 * $Revision: 1.26.4.3 $
 * $Date: 2004/04/14 23:44:39 $ 
 */

/*==========*
 * Includes *
 *==========*/

#if defined(MATLAB_MEX_FILE)
# error "rt_matrix cannot be used within a mex file. It is for RTW only."
#endif

#include <stdlib.h>    /* needed for malloc, calloc, free, realloc */
#include <string.h>    /* needed for strlen                        */
#include "rtwtypes.h"  /* needed for real_T                        */
#include "rt_mxclassid.h" /* needed for mxClassID                     */



/*==========*
 * Typedefs *
 *==========*/

#ifndef rt_typedefs_h
#define rt_typedefs_h

#if !defined(TYPEDEF_MX_ARRAY)
# define TYPEDEF_MX_ARRAY
  typedef real_T mxArray;
#endif

typedef real_T mxChar;

#define mxMAXNAM  TMW_NAME_LENGTH_MAX	/* maximum name length */

typedef enum {
    mxREAL,
    mxCOMPLEX
} mxComplexity;

#ifdef V4_COMPAT
typedef double Real;    /* mimic MATLAB 4's matrix.h */
#define Matrix  mxArray
#define COMPLEX mxCOMPLEX
#define REAL    mxREAL
#endif

#endif /* rt_typedefs_h */

/*==================*
 * Extern variables *
 *==================*/

extern real_T rtInf;
extern real_T rtMinusInf;
extern real_T rtNaN;

/*=======================================*
 * Defines for mx Routines and constants *
 *=======================================*/


#define mxCalloc(n,size) \
        calloc(n,size)

#define mxCreateCharArray(ndim, dims) \
        mxCreateNumericArray(ndim, dims, mxCHAR_CLASS);

#define mxDestroyArray(pa) \
        if (pa) free(pa)

/* NOTE: You cannot mxFree(mxGetPr(pa)) !!! */
#define mxFree(ptr) \
        if(ptr)free(ptr)

#define mxGetClassID(pa) \
        mxDOUBLE_CLASS

/* NOTE: mxGetClassName(pa) returns "double" even on a character array */
#define mxGetClassName(pa) \
        "double"

#define mxGetData(pa) \
        ((void *)(&((pa)[2])))

#define mxGetElementSize(pa) \
        (sizeof(real_T))

#define mxGetInf() \
        rtInf

#define mxGetM(pa) \
        ((int) ((pa)[0]))
#define mxGetN(pa) \
        ((int) ((pa)[1]))

#define mxGetNaN() \
        rtNaN

#define mxGetNumberOfDimensions(pa) \
        (2)
#define mxGetNumberOfElements(pa) \
        (mxGetM(pa)*mxGetN(pa))

/* NOTE: mxGetPr() of an empty matrix does NOT return NULL */
#define mxGetPr(pa) \
        ( &((pa)[2]) )

#define mxGetScalar(pa) \
        ((pa)[2])

#define mxIsComplex(pa) \
        false

#define mxIsDouble(pa) \
        true

#define mxIsEmpty(pa) \
        (mxGetM(pa)==0 || mxGetN(pa)==0)

#define mxIsFinite(r) \
        ((r)>rtMinusInf && (r)<rtInf)

#define mxIsInf(r) \
        ((r)==rtInf || (r)==rtMinusInf)

#define mxIsInt16(pa) \
        false

#define mxIsInt32(pa) \
        false

#define mxIsInt8(pa) \
        false

#define mxIsLogical(pa) \
        false

#define mxIsNumeric(pa) \
        true

#define mxIsSingle(pa) \
        false

#define mxIsSparse(pa) \
        false

#define mxIsStruct(pa) \
        false

#define mxIsUint16(pa) \
        false

#define mxIsUint32(pa) \
        false

#define mxIsUint8(pa) \
        false

#define mxMalloc(n) \
        malloc(n)

#define mxRealloc(p,n) \
        realloc(p,n)





/*==========================*
 * Visible/extern functions *
 *=========================*/

extern mxArray *rt_mxCreateCharMatrixFromStrings(int_T m, const char_T **str);

extern mxArray *rt_mxCreateString(const char *str);

extern mxArray *rt_mxCreateDoubleMatrix(int m, int n, mxComplexity flag);

extern mxArray *rt_mxCreateNumericArray(int_T ndims, const int_T *dims,
                                     mxClassID classid, mxComplexity flag);

extern mxArray *rt_mxDuplicateArray(const mxArray *pa);

extern const int_T *rt_mxGetDimensions(const mxArray *pa);

extern real_T rt_mxGetEps(void);

extern int_T rt_mxGetString(const mxArray *pa, char_T *buf, int_T buflen);



#define mxCreateCharMatrixFromStrings(m, str) \
        rt_mxCreateCharMatrixFromStrings(m, str)

#define mxCreateString(str) \
        rt_mxCreateString(str) 

#define mxCreateDoubleMatrix(m, n, flag) \
        rt_mxCreateDoubleMatrix(m, n, flag)

#define mxCreateNumericArray(ndims, dims, classid, flag) \
        rt_mxCreateNumericArray(ndims, dims, classid, flag)

#define mxDuplicateArray(pa) \
        rt_mxDuplicateArray(pa)

#define mxGetDimensions(pa) \
        rt_mxGetDimensions(pa)

#define mxGetEps() \
        rt_mxGetEps()

#define mxGetString(pa, buf, buflen) \
        rt_mxGetString(pa, buf, buflen)

/*=========================*
 * Unsupported mx Routines *
 *=========================*/

#define mxCalcSingleSubscript(pa,nsubs,subs) \
        mxCalcSingleSubscript_is_not_supported_in_RTW

#define mxClearLogical(pa) \
        mxClearLogical_is_not_supported_in_RTW

#define mxCreateCellArray(ndim,dims) \
        mxCreateCellArray_is_not_supported_in_RTW

#define mxCreateCellMatrix(m,n) \
        mxCreateCellMatrix_is_not_supported_in_RTW

#define mxCreateSparse(pm,pn,pnzmax,pcmplx_flg) \
        mxCreateSparse_is_not_supported_in_RTW

#define mxCreateStructArray(ndim,dims,nfields,fieldnames) \
        mxCreateStructArray_is_not_supported_in_RTW

#define mxCreateStructMatrix(m,n,nfields,fieldnames) \
        mxCreateStructMatrix_is_not_supported_in_RTW

#define mxGetCell(pa,i) \
        mxGetCell_is_not_supported_in_RTW

#define mxGetField(pa,i,fieldname) \
        mxGetField_is_not_supported_in_RTW

#define mxGetFieldByNumber(s,i,fieldnum) \
        mxGetFieldByNumber_is_not_supported_in_RTW

#define mxGetFieldNameByNumber(pa,n) \
        mxGetFieldNameByNumber_is_not_supported_in_RTW

#define mxGetFieldNumber(pa,fieldname) \
        mxGetFieldNumber_is_not_supported_in_RTW

#define mxGetImagData(pa) \
        mxGetImagData_is_not_supported_in_RTW

#define mxGetIr(ppa) \
        mxGetIr_is_not_supported_in_RTW

#define mxGetJc(ppa) \
        mxGetJc_is_not_supported_in_RTW

#define mxGetNumberOfFields(pa) \
        mxGetNumberOfFields_is_not_supported_in_RTW

#define mxGetNzmax(pa) \
        mxGetNzmax_is_not_supported_in_RTW

#define mxGetPi(pa) \
        mxGetPi_is_not_supported_in_RTW

#define mxIsFromGlobalWS(pa) \
        mxIsFromGlobalWS_is_not_supported_in_RTW

#define mxIsNaN(r) \
        mxIsNaN_is_not_supported_in_RTW

#define mxIsChar(pa) \
        mxIsChar_is_not_supported_in_RTW

#define mxIsClass(pa,class) \
        mxIsClass_is_not_supported_in_RTW

#define mxIsCell(pa) \
        mxIsCell_is_not_supported_in_RTW

#define mxSetCell(pa,i,value) \
        mxSetCell_is_not_supported_in_RTW

#define mxSetClassName(pa,classname) \
        mxSetClassName_is_not_supported_in_RTW

#define mxSetData(pa,pr) \
        mxSetData_is_not_supported_in_RTW

#define mxSetDimensions(pa, size, ndims) \
        mxSetDimensions_is_not_supported_in_RTW

#define mxSetField(pa,i,fieldname,value) \
        mxSetField_is_not_supported_in_RTW

#define mxSetFieldByNumber(pa, index, fieldnum, value) \
        mxSetFieldByNumber_is_not_supported_in_RTW

#define mxSetFromGlobalWS(pa,global) \
        mxSetFromGlobalWS_is_not_supported_in_RTW

#define mxSetImagData(pa,pv) \
        mxSetImagData_is_not_supported_in_RTW

#define mxSetIr(ppa,ir) \
        mxSetIr_is_not_supported_in_RTW

#define mxSetJc(ppa,jc) \
        mxSetJc_is_not_supported_in_RTW

#define mxSetLogical(pa) \
        mxSetLogical_is_not_supported_in_RTW

#define mxSetM(pa, m) \
        mxSetM_is_not_supported_in_RTW

#define mxSetN(pa, m) \
        mxSetN_is_not_supported_in_RTW

#define mxSetPr(pa,pr) \
        mxSetPr_is_not_supported_in_RTW

#define mxSetNzmax(pa,nzmax) \
        mxSetNzmax_is_not_supported_in_RTW

#define mxSetPi(pa,pv) \
        mxSetPi_is_not_supported_in_RTW



/*======================*
 * Obsolete mx routines *
 *======================*/

#ifdef V4_COMPAT
# define mxIsFull(pa)              (!mxIsSparse(pa))
# define mxCreateFull(m,n,complex) mxCreateDoubleMatrix(m,n,complex)
# define mxFreeMatrix(pm)          mxDestroyArray(pm)
#else
# define mxCreateFull(m,n,complex) mxCreateFull_is_obsolete
# define mxFreeMatrix(p)           mxFreeMatrix_is_obsolete
# define mxIsFull(pa)              mxIsFull_is_obsolete
# define mxIsString(pm)            mxIsString_is_obsolete
# define mxGetName(pa)             mxGetName_is_obsolete
# define mxSetName(ppa,name)       mxSetName_is_obsolete
#endif


/*==========================*
 * Unsupported mex routines *
 *==========================*/

#define mexPrintAssertion(test,fname,linenum,message) \
        mexPrintAssertion_is_not_supported_by_RTW

#define mexEvalString(str) \
        mexEvalString_is_not_supported_by_RTW

#define mexErrMsgTxt(str) \
        mexErrMsgTxt_is_not_supported_by_RTW

#define mexWarnMsgTxt(warning_msg) \
        mexWarnMsgTxt_is_not_supported_by_RTW

#define mexPrintf \
        mexPrintf_is_not_supported_by_RTW

#define mexMakeArrayPersistent(pa) \
        mexMakeArrayPersistent_is_not_supported_by_RTW

#define mexMakeMemoryPersistent(ptr) \
        mexMakeMemoryPersistent_is_not_supported_by_RTW

#define mexLock() \
        mexLock_is_not_supported_by_RTW

#define mexUnlock() \
        mexUnlock_is_not_supported_by_RTW

#define mexFunctionName() \
        mexFunctionName_is_not_supported_by_RTW

#define mexIsLocked() \
        mexIsLocked_is_not_supported_by_RTW

#define mexGetFunctionHandle() \
        mexGetFunctionHandle_is_not_supported_by_RTW

#define mexCallMATLABFunction() \
        mexCallMATLABFunction_is_not_supported_by_RTW

#define mexRegisterFunction() \
        mexRegisterFunction_is_not_supported_by_RTW

#define mexSet(handle,property,value) \
        mexSet_is_not_supported_by_RTW

#define mexGet(handle,property) \
        mexGet_is_not_supported_by_RTW

#define mexPutArray(pm,workspace) \
        mexPutArray_is_not_supported_by_RTW

#define mexGetArrayPtr(name,workspace) \
        mexGetArrayPtr_is_not_supported_by_RTW

#define mexGetArray(name,workspace) \
        mexGetArray_is_not_supported_by_RTW

#define mexCallMATLAB(nlhs,plhs,nrhs,prhs,fcn) \
        mexCallMATLAB_is_not_supported_by_RTW

#define mexSetTrapFlag(flag) \
        mexSetTrapFlag_is_not_supported_by_RTW

#define mexUnlink(a) \
        mexUnlink_is_not_supported_by_RTWw

#define mexSubsAssign(plhs,sub,nsubs,prhs) \
        mexSubsAssign_is_not_supported_by_RTW

#define mexSubsReference(prhs,subs,nsubs) \
        mexSubsReference_is_not_supported_by_RTW

#define mexPrintAssertion(test,fname,linenum,message) \
        mexPrintAssertion_is_not_supported_by_RTW

#define mexAddFlops(count) \
        mexAddFlops_is_not_supported_by_RTW

#define mexIsGlobal(pa) \
        mexIsGlobal_is_not_supported_by_RTW

#define mexAtExit(fcn) \
        mexAtExit_is_not_supported_by_RTW


#endif /* rt_matrx_h */
