/*
 * Copyright 2004 The MathWorks, Inc.
 *
 * File: rtw_capi_examples.h     $Revision: 1.1.4.1 $
 *
 * Abstract:
 *   Provides utility functions to traverse and access RTW generated C-API
 *   structures. The C-API structure types are provided in following 2 files.
 *
 *       matlabroot/rtw/c/src/rtw_capi.h & rtw_modelmap.h
 *
 *   The actual data structures are generated by code generator in 
 *   <MODEL>_capi.c, where <MODEL> is the name of the model.
 * 
 *   The functions provided in this file are
 *       capi_PrintModelParameter - Prints a model parameter value to STDOUT
 */

#ifndef __RTW_CAPI_EXAMPLES_H__
# define __RTW_CAPI_EXAMPLES_H__

#include <stdio.h>
#include <assert.h>
#include <math.h>
#include "rtwtypes.h"
#include "rtw_modelmap.h"

extern void capi_PrintModelParameter(rtwCAPI_ModelMappingInfo* capiMap,  
                                     uint_T                    paramIdx);
 
extern void capi_PrintParameter(const char_T*  paramName,
                                void*          paramAddress,
                                uint8_T        slDataId,
                                unsigned short isComplex,
                                uint_T*        actDims,
                                uint_T         numDims,
                                real_T         slope,
                                real_T         bias);

extern int_T capi_ModifyModelParameter(rtwCAPI_ModelMappingInfo* capiMap,
                                       uint_T                    paramIdx,
                                       void*                     newParam);

extern int_T capi_ModifyParameter(void                 *_param,
                                  void                 *_newParam,
                                  rtwCAPI_Orientation  orientation,
                                  uint_T               *dims,
                                  uint8_T              nDims,
                                  uint8_T              slDataType,
                                  unsigned short       isComplex);

#endif

/* EOF - rtw_capi_example.h */

