#include "tmwtypes.h"

#include "kernel/kern.h"
#include "cabs/cabs/cabs.h"

#include "plant_model.h"
#include "Veicolo0_ert_rtw/Veicolo0.h"

/*=========*
 * Defines *
 *=========*/

#define PLANT_OFF_Y    5

#ifndef TRUE
#define FALSE (0)
#define TRUE  (1)
#endif

#ifndef EXIT_FAILURE
#define EXIT_FAILURE  1
#endif
#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS  0
#endif

#define QUOTE1(name) #name
#define QUOTE(name) QUOTE1(name)    /* needed to expand name    */

#define RUN_FOREVER -1.0

#define EXPAND_CONCAT(name1,name2) name1 ## name2
#define CONCAT(name1,name2) EXPAND_CONCAT(name1,name2)
#define RT_MODEL            CONCAT(MODEL,_rtModel)
#define MODELNAME           CONCAT(MODEL,_M);

#define EXTINPUTS_T         CONCAT(ExternalInputs_,MODEL)
#define EXTOUTPUTS_T        CONCAT(ExternalOutputs_,MODEL)

#define _INPUTPORT_BASE     CONCAT(Inport,1)
#define _OUTPUTPORT_BASE    CONCAT(Outport,OUTBASE)

#define EXTINPUTS           CONCAT(MODEL,_U)
#define EXTOUTPUTS          CONCAT(MODEL,_Y)
           
#define _INPUTPORT          EXTINPUTS._INPUTPORT_BASE
#define _OUTPUTPORT         EXTOUTPUTS._OUTPUTPORT_BASE

#define INPORT(i)           (*(&(_INPUTPORT) + i))
#define OUTPORT(i)          (*(&(_OUTPUTPORT) + i))

#define MODELINIT           CONCAT(MODEL,_initialize)
#define MODELCLOSE          CONCAT(MODEL,_terminate)

CAB    input_cid[N_ACTUATORS];
CAB    output_cid[N_SENSORS];

/*==================================*
 * Global data local to this module *
 *==================================*/

/* RT_MODEL   *S; */
const char *status;
real_T     finaltime = -2.0;
int        simulation_run;

extern EXTINPUTS_T EXTINPUTS;
extern EXTOUTPUTS_T EXTOUTPUTS;

extern void rt_OneStep(void);

/*-----------------------------------------------------*/
/* Initialize the variables for the model of the plant */
/* It must be called from the main before activating   */
/* any task */
void Init_RealTime_Workshop() 
{
  MODELINIT(1);
}


/*-----------------------------------------------------------------*/
/* Closes all the open descriptors and exits in a clean way */
/* must be called before the return to dos */
void Close_RealTime_Workshop() 
{
  MODELCLOSE();
}


/*-------------------------------------------------------------------*/
/* Task that simulates the plant. In this case, the "Veicolo" model */
TASK RTW_body(void *arg) {
  int i;
  real_T *input, *output, *p;

  simulation_run = 1;

  while (1) {

    task_nopreempt();
    for (i=0; i<N_ACTUATORS; i++) {
      if (INPORT(i) != -1) {
	p = (real_T *)cab_getmes(input_cid[i]);
	INPORT(i) = *p;
	cab_unget(input_cid[i], p);
      }
    }
    task_preempt();
    

/*     for (i=0; i<N_ACTUATORS; i++) {  */
/*       printf_xy(0,PLANT_OFF_Y +i, WHITE, "rtU.input%d: %d", i, (int)INPORT(i)); */
/*     } */

    rt_OneStep();

/*     for (i=0; i<N_SENSORS; i++) { */
/*       printf_xy(0,PLANT_OFF_Y+OUTBASE+i, WHITE, "rtY.output%i: %d", i,  */
/* 		(int)OUTPORT(i)); */
/*     } */

    task_endcycle();

  }

  simulation_run = 0;

  return NULL;

}


/*------------------------------------------------------------*/
/* Index can be                                               */
/* 0: voltage on right motor                                  */
/* 1: voltage on left motor                                   */
/*------------------------------------------------------------*/
void actuate(double v, int index)
{
  real_T *p;

  /* Reserve a message */
  p = (real_T *)cab_reserve(input_cid[index]);
  
  *p = v;

  /* Put CAB message */
  cab_putmes(input_cid[index], p);
}

static  PID RTW_pid;

/* --------------------------------------------------------- */
/* Initilizes all tasks to perform the simulation, and in    */
/* particular, the RTW_task that simulates the plant,        */
void Init_Rtw() {

  char cabname[15];
  HARD_TASK_MODEL     RTW_task,OUTPUT_task;

  int i;

  int RTW_period;
  int RTW_wcet;

  int OUTPUT_period;
  int OUTPUT_wcet;
  int OUTPUT_w_period;
  int OUTPUT_w_wcet;

  Init_RealTime_Workshop();

  for (i=0;i<N_ACTUATORS;i++) {
    input_cid[i] = -1;
    sprintf(cabname,"input%d",i);
    input_cid[i] = cab_create(cabname, sizeof(real_T), 4);
  }

  for (i=0;i<N_SENSORS;i++) {
    output_cid[i] = -1;
    sprintf(cabname,"output%d",i);
    output_cid[i] = cab_create(cabname, sizeof(real_T), 4);
  }

  RTW_period = 1000;
  RTW_wcet = RTW_WCET;

  cprintf("Task Setup\n");
  cprintf("RTW    (P %8d W %8d)\n",RTW_period,RTW_wcet);

  hard_task_default_model(RTW_task);
  hard_task_def_mit(RTW_task,RTW_period);
  hard_task_def_wcet(RTW_task,RTW_wcet);
  hard_task_def_usemath(RTW_task);
  hard_task_def_ctrl_jet(RTW_task);

  RTW_pid = task_create("RTW", RTW_body, &RTW_task, NULL);
  if (RTW_pid == NIL) {
    cprintf("Error: Cannot create RealTime Workshop [RTW] Task\n");
    exit(-1);
  }                                                                             }

int simulationStart()
{
  task_activate(RTW_pid);
  
  return RTW_pid;
}

int simulationIsRunning()
{
  return simulation_run;
}

real_T * plant_getY()
{
  return &EXTOUTPUTS;
}
