#include "tmwtypes.h"

#include "kernel/kern.h"
#include "cabs/cabs/cabs.h"

#include "plant_model.h"


#define SENSOR_OFF_Y    20

extern CAB output_cid[N_SENSORS];


double read_sensor(int index)
{ 
  double value;

  if (index >= N_SENSORS || index < 0) return -1000.0; 
  real_T* p = (real_T *)cab_getmes(output_cid[index]);
  value = *p;
  cab_unget(output_cid[index], p);

  return value;
}

static int *sensor_array;
static int sensor_number=0;

/* --------------------------------------------------------- */
/* Task that simulates an acquisition board. Reads the       */
/* output data from the model and writes then in the cabs.   */
/* The user can then access the cabs directly                */
TASK SENSOR_body(void *arg) 
{
  real_T *output, *p;
  int i,j;
  double v;

  while(1) {

    task_nopreempt();
    output = plant_getY();
    for (i=0; i<sensor_number; i++) {
      j = sensor_array[i];

      p = (real_T *)cab_reserve(output_cid[j]);
      *p = output[j];
      cab_putmes(output_cid[j], p);

      v = output[j];

      printf_xy(0, SENSOR_OFF_Y+i, WHITE, "v = %d", (int)v);
    }   
    task_preempt();

    task_endcycle();
  }
  return NULL;
}


/*
  Initializes the board specifying:

  - the array of sensor index to be read (sarray)
  - the number of sensors to be read (nsensors)
  - the sampling period 
  - the wcet of the simulating task
  - the task name

  It creates the task
 */
PID init_sensor_board(int sarray[], int nsensors, int period, int wcet, char *name)
{
  int i;
  HARD_TASK_MODEL OUTPUT_task;
  PID             OUTPUT_pid;

  //  sensor_array=malloc(nsensors * sizeof(int));
  sensor_number = nsensors;

  printf_xy(60, 13, WHITE, "nsensors %d", nsensors);

  for (i=0; i<nsensors; i++) {
    sensor_array[i] = sarray[i];
  }

  hard_task_default_model(OUTPUT_task);
  hard_task_def_usemath(OUTPUT_task);
  hard_task_def_ctrl_jet(OUTPUT_task);
  hard_task_def_mit(OUTPUT_task, period);
  hard_task_def_wcet(OUTPUT_task, wcet);

  OUTPUT_pid = task_create(name, SENSOR_body, &OUTPUT_task, NULL);
  if (OUTPUT_pid == NIL) {
    cprintf("Error: Cannot create RealTime Workshop [%s] Task\n", name);
    exit(-1);
  }  

  task_activate(OUTPUT_pid);
  
  return OUTPUT_pid;
}







