#ifndef __SENSOR_H__
#define __SENSOR_H__

/*------------------------------------------------------------*/
/* Index is the index of the sensor                           */
/*                                                            */
/* returns: the value read by the sensor                      */
/*------------------------------------------------------------*/
double read_sensor(int index);

/*------------------------------------------------------------*/
/*   Initializes the board specifying:                        */
/*   - the array of sensor index to be read (sarray)          */
/*   - the number of sensors to be read (nsensors)            */
/*   - the sampling period                                    */
/*   - the wcet of the simulating task                        */
/*   - the task name                                          */
/*   It creates the task that will periodically sample the    */
/*   sensors                                                  */
/*------------------------------------------------------------*/
PID init_sensor_board(int sarray[], int nsensors, int period, int wcet, char *name);

#endif
